/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.checks.world;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import jn.willfrydev.xanticheat.XAntiCheat;
import jn.willfrydev.xanticheat.checks.Check;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerMoveEvent;

public class Scaffold
extends Check
implements Listener {
    private final Map<UUID, Integer> violationLevels = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> lastPlaceTime = new HashMap<UUID, Long>();
    private final Map<UUID, Integer> towerStreak = new HashMap<UUID, Integer>();
    private static final int VL_THRESHOLD = 15;
    private static final long TOWER_TIME_THRESHOLD = 100L;

    public Scaffold(XAntiCheat plugin) {
        super(plugin, "scaffold");
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE || player.getAllowFlight() || player.isFlying()) {
            return;
        }
        this.checkTower(player, event);
        this.checkInvalidAngle(player, event);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getPlayer().isOnGround() && (event.getFrom().getBlockX() != event.getTo().getBlockX() || event.getFrom().getBlockZ() != event.getTo().getBlockZ())) {
            this.towerStreak.put(event.getPlayer().getUniqueId(), 0);
        }
    }

    private void checkTower(Player player, BlockPlaceEvent event) {
        Location playerLoc = player.getLocation();
        Location blockLoc = event.getBlockPlaced().getLocation();
        if (playerLoc.getBlockX() == blockLoc.getBlockX() && playerLoc.getBlockZ() == blockLoc.getBlockZ() && playerLoc.getBlockY() - 1 == blockLoc.getBlockY()) {
            long currentTime = System.currentTimeMillis();
            long lastTime = this.lastPlaceTime.getOrDefault(player.getUniqueId(), 0L);
            long timeDiff = currentTime - lastTime;
            if (player.getVelocity().getY() > 0.0 && timeDiff < 100L) {
                int streak = this.towerStreak.getOrDefault(player.getUniqueId(), 0) + 1;
                this.towerStreak.put(player.getUniqueId(), streak);
                if (streak > 3) {
                    this.incrementVL(player, "Tower (Speed: " + timeDiff + "ms)");
                }
            }
            this.lastPlaceTime.put(player.getUniqueId(), currentTime);
        }
    }

    private void checkInvalidAngle(Player player, BlockPlaceEvent event) {
        float pitch = player.getLocation().getPitch();
        if (pitch < 70.0f) {
            double dz;
            Location playerLoc = player.getLocation();
            Location blockLoc = event.getBlockPlaced().getLocation();
            double dx = playerLoc.getX() - (blockLoc.getX() + 0.5);
            double horizontalDistance = Math.sqrt(dx * dx + (dz = playerLoc.getZ() - (blockLoc.getZ() + 0.5)) * dz);
            if (horizontalDistance < 0.5 && playerLoc.getY() > blockLoc.getY()) {
                this.incrementVL(player, "Invalid Angle (Pitch: " + String.format("%.2f", Float.valueOf(pitch)) + ")");
            }
        }
    }

    private void incrementVL(Player player, String reason) {
        int vl = this.violationLevels.getOrDefault(player.getUniqueId(), 0) + 1;
        this.violationLevels.put(player.getUniqueId(), vl);
        if (vl > 15) {
            super.flag(player);
            this.violationLevels.put(player.getUniqueId(), 0);
        }
    }
}

