/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.manager;

import java.util.ArrayList;
import java.util.List;
import jn.willfrydev.xanticheat.XAntiCheat;
import jn.willfrydev.xanticheat.checks.Check;
import jn.willfrydev.xanticheat.checks.combat.AutoClicker;
import jn.willfrydev.xanticheat.checks.combat.Reach;
import jn.willfrydev.xanticheat.checks.combat.Velocity;
import jn.willfrydev.xanticheat.checks.movement.Jesus;
import jn.willfrydev.xanticheat.checks.movement.NoFall;
import jn.willfrydev.xanticheat.checks.movement.NoSlowDown;
import jn.willfrydev.xanticheat.checks.movement.Speed;
import jn.willfrydev.xanticheat.checks.world.Scaffold;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class CheckManager {
    private final XAntiCheat plugin;
    private final List<Check> registeredChecks = new ArrayList<Check>();

    public CheckManager(XAntiCheat plugin) {
        this.plugin = plugin;
    }

    public void registerChecks() {
        this.addCheck(new Speed(this.plugin));
        this.addCheck(new Velocity(this.plugin));
        this.addCheck(new NoSlowDown(this.plugin));
        this.addCheck(new NoFall(this.plugin));
        this.addCheck(new Jesus(this.plugin));
        this.addCheck(new NoFall(this.plugin));
        this.addCheck(new AutoClicker(this.plugin));
        this.addCheck(new Reach(this.plugin));
        this.addCheck(new Scaffold(this.plugin));
        this.plugin.getLogger().info("Se han registrado y activado " + this.registeredChecks.size() + " checks.");
    }

    private void addCheck(Check check) {
        if (check instanceof Listener) {
            this.registeredChecks.add(check);
            Bukkit.getPluginManager().registerEvents((Listener)check, (Plugin)this.plugin);
        } else {
            this.plugin.getLogger().warning("El check " + check.getClass().getSimpleName() + " no es un Listener y no puede ser registrado.");
        }
    }

    public List<Check> getRegisteredChecks() {
        return this.registeredChecks;
    }
}

