/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.manager;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import jn.willfrydev.xanticheat.XAntiCheat;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class ClientManager
implements PluginMessageListener {
    private final XAntiCheat plugin;
    private final Map<UUID, String> clientBrands = new ConcurrentHashMap<UUID, String>();
    private static final String BRAND_CHANNEL = "minecraft:brand";

    public ClientManager(XAntiCheat plugin) {
        this.plugin = plugin;
    }

    public String getClientBrand(UUID playerUUID) {
        return this.clientBrands.getOrDefault(playerUUID, "Desconocido");
    }

    public void onPlayerJoin(Player player) {
    }

    public void onPlayerQuit(Player player) {
        this.clientBrands.remove(player.getUniqueId());
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (!channel.equalsIgnoreCase(BRAND_CHANNEL)) {
            return;
        }
        String brand = new String(message, StandardCharsets.UTF_8);
        if (!brand.isEmpty() && brand.charAt(0) < '\u0014') {
            brand = brand.substring(1);
        }
        this.clientBrands.put(player.getUniqueId(), brand);
        this.plugin.getLogger().info("Marca de cliente detectada para " + player.getName() + ": " + brand);
    }
}

