/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.manager;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import jn.willfrydev.xanticheat.XAntiCheat;
import jn.willfrydev.xanticheat.libs.hikaricp.HikariConfig;
import jn.willfrydev.xanticheat.libs.hikaricp.HikariDataSource;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DatabaseManager {
    private final XAntiCheat plugin;
    private HikariDataSource dataSource;

    public DatabaseManager(XAntiCheat plugin) {
        this.plugin = plugin;
        this.connect();
        this.initTables();
    }

    private void connect() {
        try {
            File dbFile = new File(this.plugin.getDataFolder(), "data.db");
            if (!dbFile.exists()) {
                dbFile.getParentFile().mkdirs();
                dbFile.createNewFile();
            }
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl("jdbc:sqlite:" + dbFile.getAbsolutePath());
            config.setConnectionTestQuery("SELECT 1");
            config.setMaxLifetime(60000L);
            config.setIdleTimeout(45000L);
            config.setMaximumPoolSize(10);
            this.dataSource = new HikariDataSource(config);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "No se pudo crear el archivo de la base de datos.", e);
        }
    }

    public void disconnect() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }

    private void initTables() {
        try (Connection conn = this.dataSource.getConnection();
             Statement statement = conn.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS player_violations (uuid VARCHAR(36) NOT NULL, check_name VARCHAR(32) NOT NULL, violations INT NOT NULL, PRIMARY KEY (uuid, check_name));");
            statement.execute("CREATE TABLE IF NOT EXISTS xac_logs (id INTEGER PRIMARY KEY AUTOINCREMENT, timestamp DATETIME DEFAULT CURRENT_TIMESTAMP, uuid VARCHAR(36), player_name VARCHAR(16), check_name VARCHAR(32), details TEXT, ping INT, tps DOUBLE);");
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "No se pudo inicializar una tabla de la base de datos.", e);
        }
    }

    public void logViolationAsync(UUID uuid, String playerName, String checkName, String details, int ping, double tps) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            String sql = "INSERT INTO xac_logs (uuid, player_name, check_name, details, ping, tps) VALUES (?, ?, ?, ?, ?, ?);";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, uuid.toString());
                ps.setString(2, playerName);
                ps.setString(3, checkName);
                ps.setString(4, details);
                ps.setInt(5, ping);
                ps.setDouble(6, tps);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "No se pudo guardar un registro de violaci\u00f3n.", e);
            }
        });
    }

    public Map<String, Integer> loadViolations(UUID uuid) {
        HashMap<String, Integer> violations = new HashMap<String, Integer>();
        String sql = "SELECT check_name, violations FROM player_violations WHERE uuid = ?;";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                violations.put(rs.getString("check_name"), rs.getInt("violations"));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "No se pudieron cargar las violaciones para " + uuid, e);
        }
        return violations;
    }

    public void saveViolations(UUID uuid, Map<String, Integer> violations) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            String sql = "INSERT OR REPLACE INTO player_violations (uuid, check_name, violations) VALUES (?, ?, ?);";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                for (Map.Entry entry : violations.entrySet()) {
                    ps.setString(1, uuid.toString());
                    ps.setString(2, (String)entry.getKey());
                    ps.setInt(3, (Integer)entry.getValue());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "No se pudieron guardar las violaciones para " + uuid, e);
            }
        });
    }
}

