/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.manager;

import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.net.ssl.HttpsURLConnection;
import jn.willfrydev.xanticheat.XAntiCheat;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.json.JSONArray;
import org.json.JSONObject;

public class DiscordManager {
    private final XAntiCheat plugin;

    public DiscordManager(XAntiCheat plugin) {
        this.plugin = plugin;
    }

    public void sendPunishmentMessage(Player player, String checkName, String reason, int maxVl) {
        if (!this.plugin.getConfig().getBoolean("discord.enabled", false)) {
            return;
        }
        String webhookURL = this.plugin.getConfig().getString("discord.webhook_url");
        if (webhookURL == null || webhookURL.trim().isEmpty()) {
            this.plugin.getLogger().warning("La integraci\u00f3n con Discord est\u00e1 activada pero la Webhook URL est\u00e1 vac\u00eda.");
            return;
        }
        String playerName = player.getName();
        String playerUUID = player.getUniqueId().toString();
        int ping = player.getPing();
        double tps = Bukkit.getServer().getTPS()[0];
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String username = this.plugin.getConfig().getString("discord.username", "xAntiCheat");
                String avatarUrl = this.plugin.getConfig().getString("discord.avatar_url", "");
                JSONObject embed = new JSONObject();
                embed.put("title", "Jugador Sancionado");
                embed.put("color", 15158332);
                JSONObject author = new JSONObject();
                author.put("name", playerName + " (Vanilla)");
                author.put("icon_url", "https://crafatar.com/avatars/" + playerUUID + "?size=64");
                embed.put("author", author);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                embed.put("timestamp", sdf.format(new Date()));
                JSONArray fields = new JSONArray();
                fields.put(new JSONObject().put("name", "Raz\u00f3n de la Sanci\u00f3n").put("value", reason).put("inline", false));
                fields.put(new JSONObject().put("name", "Check Activado").put("value", checkName).put("inline", true));
                fields.put(new JSONObject().put("name", "Violaciones").put("value", maxVl + "/" + maxVl).put("inline", true));
                fields.put(new JSONObject().put("name", "Ping / TPS").put("value", ping + "ms / " + new DecimalFormat("#.##").format(tps)).put("inline", true));
                embed.put("fields", fields);
                JSONObject jsonPayload = new JSONObject();
                jsonPayload.put("username", username);
                jsonPayload.put("avatar_url", avatarUrl);
                jsonPayload.put("embeds", new JSONArray().put(embed));
                HttpsURLConnection connection = (HttpsURLConnection)new URL(webhookURL).openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                connection.setRequestProperty("User-Agent", "xAntiCheat-Webhook");
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    os.write(jsonPayload.toString().getBytes(StandardCharsets.UTF_8));
                }
                int responseCode = connection.getResponseCode();
                if (responseCode >= 300) {
                    this.plugin.getLogger().warning("Error al enviar el mensaje a Discord. C\u00f3digo de respuesta: " + responseCode);
                }
                connection.disconnect();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("No se pudo enviar el mensaje a Discord. Excepci\u00f3n: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }
}

