/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerMoveEvent;

public class FreezeManager
implements Listener {
    private final Map<UUID, Location> frozenPlayers = new HashMap<UUID, Location>();

    public void freezePlayer(Player player) {
        this.frozenPlayers.put(player.getUniqueId(), player.getLocation());
    }

    public void unfreezePlayer(Player player) {
        this.frozenPlayers.remove(player.getUniqueId());
    }

    public boolean isFrozen(Player player) {
        return this.frozenPlayers.containsKey(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.isFrozen(event.getPlayer())) {
            Location freezeLocation = this.frozenPlayers.get(event.getPlayer().getUniqueId());
            if (event.getTo().getX() != freezeLocation.getX() || event.getTo().getY() != freezeLocation.getY() || event.getTo().getZ() != freezeLocation.getZ()) {
                event.getPlayer().teleport(freezeLocation);
            }
        }
    }

    @EventHandler
    public void onPlayerAttack(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player && this.isFrozen((Player)event.getDamager())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.isFrozen(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.isFrozen(event.getPlayer())) {
            event.setCancelled(true);
        }
    }
}

