/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.manager;

import java.util.List;
import java.util.stream.Collectors;
import jn.willfrydev.xanticheat.XAntiCheat;
import jn.willfrydev.xanticheat.manager.LangManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIManager {
    private final XAntiCheat plugin;
    private final LangManager lang;

    public GUIManager(XAntiCheat plugin) {
        this.plugin = plugin;
        this.lang = plugin.getLangManager();
    }

    public void openCheckGUI(Player staff, Player target) {
        String title = this.lang.getMessage("gui.title").replace("%player%", target.getName());
        int size = this.plugin.getConfig().getInt("gui.size", 27);
        Inventory gui = Bukkit.createInventory(null, (int)size, (String)title);
        ConfigurationSection checksSection = this.plugin.getConfig().getConfigurationSection("checks");
        if (checksSection == null) {
            return;
        }
        for (String checkName : checksSection.getKeys(false)) {
            int violations = this.plugin.getPlayerDataManager().getViolations(target, checkName);
            int maxViolations = checksSection.getInt(checkName + ".max_violations");
            ItemStack item = this.createCheckItem(checkName, violations, maxViolations);
            gui.addItem(new ItemStack[]{item});
        }
        staff.openInventory(gui);
    }

    private ItemStack createCheckItem(String checkName, int violations, int maxViolations) {
        String status;
        Material material = this.getMaterialForCheck(checkName);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        String displayName = this.lang.getMessage("gui.item_name").replace("%check_name%", this.capitalize(checkName));
        meta.setDisplayName(displayName);
        if (violations >= maxViolations) {
            status = this.lang.getMessage("gui.status.failed");
            meta.addEnchant(Enchantment.DURABILITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        } else {
            status = violations > maxViolations / 2 ? this.lang.getMessage("gui.status.suspicious") : this.lang.getMessage("gui.status.safe");
        }
        List lore = this.lang.getMessageList("gui.item_lore").stream().map(line -> line.replace("%violations%", String.valueOf(violations)).replace("%max_violations%", String.valueOf(maxViolations)).replace("%status%", status)).collect(Collectors.toList());
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private Material getMaterialForCheck(String checkName) {
        switch (checkName.toLowerCase()) {
            case "fly": {
                return Material.FEATHER;
            }
            case "speed": {
                return Material.SUGAR;
            }
            case "reach": {
                return Material.DIAMOND_SWORD;
            }
            case "nofall": {
                return Material.IRON_BOOTS;
            }
            case "jesus": {
                return Material.LILY_PAD;
            }
        }
        return Material.BARRIER;
    }

    private String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

