/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.manager;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import jn.willfrydev.xanticheat.XAntiCheat;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LangManager {
    private final XAntiCheat plugin;
    private FileConfiguration langConfig = null;
    private File langFile = null;

    public LangManager(XAntiCheat plugin) {
        this.plugin = plugin;
        this.saveDefaultLangFile();
    }

    public void reloadLangFile() {
        if (this.langFile == null) {
            this.langFile = new File(this.plugin.getDataFolder(), "lang.yml");
        }
        this.langConfig = YamlConfiguration.loadConfiguration((File)this.langFile);
        InputStream defaultStream = this.plugin.getResource("lang.yml");
        if (defaultStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream, StandardCharsets.UTF_8));
            this.langConfig.setDefaults((Configuration)defaultConfig);
        }
    }

    public FileConfiguration getLangConfig() {
        if (this.langConfig == null) {
            this.reloadLangFile();
        }
        return this.langConfig;
    }

    public void saveDefaultLangFile() {
        if (this.langFile == null) {
            this.langFile = new File(this.plugin.getDataFolder(), "lang.yml");
        }
        if (!this.langFile.exists()) {
            this.plugin.saveResource("lang.yml", false);
        }
    }

    public String getMessage(String path) {
        String message = this.getLangConfig().getString(path);
        if (message == null) {
            return ChatColor.RED + "Error: Mensaje no encontrado en lang.yml: " + path;
        }
        message = message.replace("%prefix%", this.getLangConfig().getString("prefix", ""));
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public List<String> getMessageList(String path) {
        return this.getLangConfig().getStringList(path).stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).collect(Collectors.toList());
    }
}

