/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import jn.willfrydev.xanticheat.XAntiCheat;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDataManager
implements Listener {
    private final XAntiCheat plugin;
    private final Map<UUID, Map<String, Integer>> violationsCache = new ConcurrentHashMap<UUID, Map<String, Integer>>();

    public PlayerDataManager(XAntiCheat plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.plugin.getClientManager().onPlayerJoin(player);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Map<String, Integer> violations = this.plugin.getDatabaseManager().loadViolations(player.getUniqueId());
            this.violationsCache.put(player.getUniqueId(), violations);
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        this.plugin.getClientManager().onPlayerQuit(player);
        Map<String, Integer> violations = this.violationsCache.get(uuid);
        if (violations != null) {
            this.plugin.getDatabaseManager().saveViolations(uuid, violations);
            this.violationsCache.remove(uuid);
        }
    }

    public void addViolation(Player player, String checkName) {
        Map playerViolations = this.violationsCache.getOrDefault(player.getUniqueId(), new HashMap());
        int currentViolations = playerViolations.getOrDefault(checkName, 0);
        playerViolations.put(checkName, currentViolations + 1);
        this.violationsCache.put(player.getUniqueId(), playerViolations);
    }

    public int getViolations(Player player, String checkName) {
        return ((Map)this.violationsCache.getOrDefault(player.getUniqueId(), new HashMap())).getOrDefault(checkName, 0);
    }

    public void clearViolations(Player player, String checkName) {
        Map<String, Integer> playerViolations = this.violationsCache.get(player.getUniqueId());
        if (playerViolations != null) {
            playerViolations.remove(checkName);
        }
    }

    public void decayAllViolations(int amount) {
        for (Map<String, Integer> playerViolations : this.violationsCache.values()) {
            playerViolations.replaceAll((check, vl) -> Math.max(0, vl - amount));
        }
    }
}

