/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xanticheat.manager;

import jn.willfrydev.xanticheat.XAntiCheat;
import org.bukkit.configuration.file.FileConfiguration;

public class SettingsManager {
    private final XAntiCheat plugin;
    private FileConfiguration config;
    public String PUNISHMENT_TYPE;
    public String PUNISHMENT_COMMAND;
    public boolean FREEZE_ENABLED;
    public int FREEZE_DURATION;
    public boolean DECAY_ENABLED;
    public int DECAY_INTERVAL;
    public int DECAY_AMOUNT;
    public String GUI_TITLE;
    public int GUI_SIZE;
    public String GUI_FILL_ITEM;
    public boolean LOGGING_DATABASE_ENABLED;
    public boolean DISCORD_ENABLED;
    public String DISCORD_WEBHOOK_URL;
    public String DISCORD_USERNAME;
    public String DISCORD_AVATAR_URL;

    public SettingsManager(XAntiCheat plugin) {
        this.plugin = plugin;
    }

    public void load() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.PUNISHMENT_TYPE = this.config.getString("punishment.type", "kick");
        this.PUNISHMENT_COMMAND = this.config.getString("punishment.command_format", "ban %player% [xAntiCheat] %reason%");
        this.FREEZE_ENABLED = this.config.getBoolean("punishment_sequence.freeze.enabled", true);
        this.FREEZE_DURATION = this.config.getInt("punishment_sequence.freeze.duration_seconds", 5);
        this.DECAY_ENABLED = this.config.getBoolean("violation_decay.enabled", true);
        this.DECAY_INTERVAL = this.config.getInt("violation_decay.interval_seconds", 300);
        this.DECAY_AMOUNT = this.config.getInt("violation_decay.amount_to_reduce", 1);
        this.GUI_TITLE = this.config.getString("gui.title", "&8xAntiCheat &7| Violaciones de &c%player%");
        this.GUI_SIZE = this.config.getInt("gui.size", 27);
        this.GUI_FILL_ITEM = this.config.getString("gui.fill_item", "GRAY_STAINED_GLASS_PANE");
        this.LOGGING_DATABASE_ENABLED = this.config.getBoolean("logging.database.enabled", true);
        this.DISCORD_ENABLED = this.config.getBoolean("discord.enabled", true);
        this.DISCORD_WEBHOOK_URL = this.config.getString("discord.webhook_url", "");
        this.DISCORD_USERNAME = this.config.getString("discord.username", "xAntiCheat");
        this.DISCORD_AVATAR_URL = this.config.getString("discord.avatar_url", "");
        this.plugin.getLogger().info("La configuraci\u00f3n (config.yml) ha sido cargada correctamente.");
    }

    public boolean isCheckEnabled(String checkName) {
        return this.config.getBoolean("checks." + checkName.toLowerCase() + ".enabled", true);
    }

    public int getMaxViolations(String checkName) {
        return this.config.getInt("checks." + checkName.toLowerCase() + ".max_violations", 20);
    }

    public String getReason(String checkName) {
        return this.config.getString("checks." + checkName.toLowerCase() + ".reason", "Comportamiento Anormal");
    }

    public double getReachMaxDistance() {
        return this.config.getDouble("checks.reach.max_distance", 3.5);
    }

    public int getVelocityThreshold() {
        return this.config.getInt("checks.velocity.reduction_threshold_percent", 95);
    }

    public int getAutoClickerMaxCPS() {
        return this.config.getInt("checks.autoclicker.max_cps", 20);
    }
}

