/*
 * Decompiled with CFR 0.152.
 */
package net.sven.svens_phantom_jockeys.entity.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.entity.player.PlayerSpawnPhantomsEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.sven.svens_phantom_jockeys.entity.ModEntities;
import net.sven.svens_phantom_jockeys.entity.custom.SkeletonPhantomJockeyEntity;

@Mod.EventBusSubscriber(modid="svens_phantom_jockeys", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PhantomJockeySpawnHandler {
    private static final float SPAWN_CHANCE = 0.5f;

    @SubscribeEvent
    public static void onPhantomSpawn(PlayerSpawnPhantomsEvent event) {
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (level.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RandomSource random = serverLevel.f_46441_;
        DifficultyInstance difficulty = serverLevel.m_6436_(player.m_20183_());
        if (!PhantomJockeySpawnHandler.shouldSpawnPhantomForPlayer(serverLevel, (ServerPlayer)player, random, difficulty)) {
            event.setResult(Event.Result.DENY);
            return;
        }
        event.setResult(Event.Result.ALLOW);
        if (random.m_188501_() < 0.5f) {
            EntityType<? extends SkeletonPhantomJockeyEntity> variant1 = PhantomJockeySpawnHandler.getRandomVariant(random);
            PhantomJockeySpawnHandler.spawnPhantomJockey(serverLevel, player, variant1, random, difficulty);
            if (3 <= event.getPhantomsToSpawn()) {
                EntityType<? extends SkeletonPhantomJockeyEntity> variant2 = PhantomJockeySpawnHandler.getRandomVariant(random);
                PhantomJockeySpawnHandler.spawnPhantomJockey(serverLevel, player, variant2, random, difficulty);
            }
        }
    }

    private static boolean shouldSpawnPhantomForPlayer(ServerLevel level, ServerPlayer player, RandomSource random, DifficultyInstance difficulty) {
        if (!level.m_46469_().m_46207_(GameRules.f_46155_)) {
            return false;
        }
        if (level.m_7445_() < 5 && level.m_6042_().f_223549_()) {
            return false;
        }
        BlockPos blockpos = player.m_20183_();
        if (blockpos.m_123342_() < level.m_5736_() || !level.m_45527_(blockpos)) {
            return false;
        }
        if (!difficulty.m_19049_(random.m_188501_() * 3.0f)) {
            return false;
        }
        ServerStatsCounter stats = player.m_8951_();
        int timeSinceRest = Mth.m_14045_((int)stats.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_)), (int)1, (int)Integer.MAX_VALUE);
        return random.m_188503_(timeSinceRest) >= 72000;
    }

    private static EntityType<? extends SkeletonPhantomJockeyEntity> getRandomVariant(RandomSource random) {
        ArrayList<EntityType> allVariants = new ArrayList<EntityType>();
        allVariants.add((EntityType)ModEntities.ZOMBIE_PHANTOM_JOCKEY.get());
        allVariants.add((EntityType)ModEntities.SKELETON_PHANTOM_JOCKEY.get());
        allVariants.add((EntityType)ModEntities.CREEPER_PHANTOM_JOCKEY.get());
        return (EntityType)allVariants.get(random.m_188503_(allVariants.size()));
    }

    private static boolean shouldSpawnJockeys(RandomSource random, DifficultyInstance difficulty) {
        float chance = 0.5f * (1.0f + difficulty.m_19057_() * 0.3f);
        return random.m_188501_() < chance;
    }

    private static List<EntityType<? extends SkeletonPhantomJockeyEntity>> getTwoRandomVariants(RandomSource random) {
        ArrayList<EntityType> allVariants = new ArrayList<EntityType>();
        allVariants.add((EntityType)ModEntities.ZOMBIE_PHANTOM_JOCKEY.get());
        allVariants.add((EntityType)ModEntities.SKELETON_PHANTOM_JOCKEY.get());
        allVariants.add((EntityType)ModEntities.CREEPER_PHANTOM_JOCKEY.get());
        Collections.shuffle(allVariants, new Random(random.m_188505_()));
        return allVariants.subList(0, 2);
    }

    private static boolean spawnPhantomJockey(ServerLevel level, Player player, EntityType<? extends SkeletonPhantomJockeyEntity> variant, RandomSource random, DifficultyInstance difficulty) {
        SkeletonPhantomJockeyEntity entity;
        BlockPos playerPos = player.m_20183_();
        BlockPos spawnPos = PhantomJockeySpawnHandler.findValidSpawnPosition(level, playerPos, random, variant);
        if (spawnPos != null && (entity = (SkeletonPhantomJockeyEntity)variant.m_20615_((Level)level)) != null) {
            entity.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, random.m_188501_() * 360.0f, 0.0f);
            entity.m_6518_((ServerLevelAccessor)level, difficulty, MobSpawnType.NATURAL, null, null);
            return level.m_7967_((Entity)entity);
        }
        return false;
    }

    private static BlockPos findValidSpawnPosition(ServerLevel level, BlockPos playerPos, RandomSource random, EntityType<?> variant) {
        for (int attempt = 0; attempt < 8; ++attempt) {
            int xOffset = -15 + random.m_188503_(31);
            int zOffset = -15 + random.m_188503_(31);
            int yOffset = 15 + random.m_188503_(16);
            BlockPos spawnPos = playerPos.m_7918_(xOffset, yOffset, zOffset);
            if (!PhantomJockeySpawnHandler.isValidSpawnPosition(level, spawnPos, variant)) continue;
            return spawnPos;
        }
        return null;
    }

    private static boolean isValidSpawnPosition(ServerLevel level, BlockPos pos, EntityType<?> variant) {
        if (pos.m_123342_() < level.m_5736_()) {
            return false;
        }
        BlockState blockState = level.m_8055_(pos);
        FluidState fluidState = level.m_6425_(pos);
        return NaturalSpawner.m_47056_((BlockGetter)level, (BlockPos)pos, (BlockState)blockState, (FluidState)fluidState, variant);
    }
}

