/*
 * Decompiled with CFR 0.152.
 */
package net.sven.svens_phantom_jockeys.entity.ai;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class RangeBowAttackGoalForJockey
extends Goal {
    private final Mob mob;
    private int attackIntervalMin;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public RangeBowAttackGoalForJockey(Mob pMob, int pAttackIntervalMin, float pAttackRadius) {
        this.mob = pMob;
        this.attackIntervalMin = pAttackIntervalMin;
        this.attackRadiusSqr = pAttackRadius * pAttackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setMinAttackInterval(int pAttackCooldown) {
        this.attackIntervalMin = pAttackCooldown;
    }

    public boolean m_8036_() {
        return this.mob.m_5448_() == null ? false : this.isHoldingBow();
    }

    protected boolean isHoldingBow() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof BowItem);
    }

    public boolean m_8045_() {
        return (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingBow();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.m_5810_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null) {
            boolean flag1;
            double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                this.mob.m_21573_().m_26573_();
                ++this.strafingTime;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.attackRadiusSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                Entity entity = this.mob.m_275832_();
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                }
                this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            } else {
                this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            }
            if (this.mob.m_6117_()) {
                int i;
                if (!flag && this.seeTime < -60) {
                    this.mob.m_5810_();
                } else if (flag && (i = this.mob.m_21252_()) >= 20) {
                    this.mob.m_5810_();
                    this.performRangedAttack(livingentity, BowItem.m_40661_((int)i));
                    this.attackTime = this.attackIntervalMin;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.mob, item -> item instanceof BowItem));
            }
        }
    }

    public void performRangedAttack(LivingEntity pTarget, float pDistanceFactor) {
        ItemStack itemstack = this.mob.m_6298_(this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.mob, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, pDistanceFactor);
        if (this.mob.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.mob.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = pTarget.m_20185_() - this.mob.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = pTarget.m_20189_() - this.mob.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.mob.m_9236_().m_46791_().m_19028_() * 4));
        this.mob.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.mob.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.mob.m_9236_().m_7967_((Entity)abstractarrow);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pVelocity) {
        return ProjectileUtil.m_37300_((LivingEntity)this.mob, (ItemStack)pArrowStack, (float)pVelocity);
    }
}

