/*
 * Decompiled with CFR 0.152.
 */
package net.sven.svens_phantom_jockeys.entity.custom;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.sven.svens_phantom_jockeys.entity.custom.SkeletonPhantomJockeyEntity;

public class CreeperPhantomJockeyEntity
extends SkeletonPhantomJockeyEntity {
    public static final float FLAP_DEGREES_PER_TICK = 7.448451f;
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)24.166098f);
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(CreeperPhantomJockeyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    Vec3 moveTargetPoint = Vec3.f_82478_;
    BlockPos anchorPoint = BlockPos.f_121853_;
    AttackPhase attackPhase = AttackPhase.CIRCLE;

    public CreeperPhantomJockeyEntity(EntityType<? extends CreeperPhantomJockeyEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 5;
        this.f_21342_ = new CreeperPhantomEntityMoveControl((Mob)this);
        this.f_21365_ = new CreeperPhantomEntityLookControl((Mob)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FlyingMob.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.5).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 2.0);
    }

    @Override
    public boolean m_142039_() {
        return (this.getUniqueFlapTickOffset() + this.f_19797_) % TICKS_PER_FLAP == 0;
    }

    @Override
    protected BodyRotationControl m_7560_() {
        return new CreeperPhantomEntityBodyRotationControl((Mob)this);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CreeperPhantomEntityAttackStrategyGoal());
        this.f_21345_.m_25352_(2, (Goal)new CreeperPhantomEntitySweepAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new CreeperPhantomEntityCircleAroundAnchorGoal());
        this.f_21346_.m_25352_(1, (Goal)new CreeperPhantomEntityAttackPlayerTargetGoal());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SIZE, (Object)0);
    }

    public void setCreeperPhantomEntitySize(int pCreeperPhantomEntitySize) {
        this.f_19804_.m_135381_(ID_SIZE, (Object)Mth.m_14045_((int)pCreeperPhantomEntitySize, (int)0, (int)64));
    }

    private void updateCreeperPhantomEntitySizeInfo() {
        this.m_6210_();
        this.m_21051_(Attributes.f_22281_).m_22100_((double)(6 + this.getCreeperPhantomEntitySize()));
    }

    public int getCreeperPhantomEntitySize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    @Override
    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.35f;
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (ID_SIZE.equals(pKey)) {
            this.updateCreeperPhantomEntitySizeInfo();
        }
        super.m_7350_(pKey);
    }

    @Override
    public int getUniqueFlapTickOffset() {
        return this.m_19879_() * 3;
    }

    @Override
    protected boolean m_8028_() {
        return true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            float f = Mth.m_14089_((float)((float)(this.getUniqueFlapTickOffset() + this.f_19797_) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            float f1 = Mth.m_14089_((float)((float)(this.getUniqueFlapTickOffset() + this.f_19797_ + 1) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12230_, this.m_5720_(), 0.95f + this.f_19796_.m_188501_() * 0.05f, 0.95f + this.f_19796_.m_188501_() * 0.05f, false);
            }
            int i = this.getCreeperPhantomEntitySize();
            float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f4 = (0.3f + f * 0.45f) * ((float)i * 0.2f + 1.0f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() + (double)f2, this.m_20186_() + (double)f4, this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() - (double)f2, this.m_20186_() + (double)f4, this.m_20189_() - (double)f3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void m_8107_() {
        if (this.m_6084_() && this.m_21527_()) {
            this.m_20254_(8);
        }
        super.m_8107_();
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("AX")) {
            this.anchorPoint = new BlockPos(pCompound.m_128451_("AX"), pCompound.m_128451_("AY"), pCompound.m_128451_("AZ"));
        }
        this.setCreeperPhantomEntitySize(pCompound.m_128451_("Size"));
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("AX", this.anchorPoint.m_123341_());
        pCompound.m_128405_("AY", this.anchorPoint.m_123342_());
        pCompound.m_128405_("AZ", this.anchorPoint.m_123343_());
        pCompound.m_128405_("Size", this.getCreeperPhantomEntitySize());
    }

    @Override
    public boolean m_6783_(double pDistance) {
        return true;
    }

    @Override
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12227_;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12231_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12229_;
    }

    @Override
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    protected float m_6121_() {
        return 1.0f;
    }

    @Override
    public boolean m_6549_(EntityType<?> pType) {
        return true;
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        int i = this.getCreeperPhantomEntitySize();
        EntityDimensions entitydimensions = super.m_6972_(pPose);
        float f = (entitydimensions.f_20377_ + 0.2f * (float)i) / entitydimensions.f_20377_;
        return entitydimensions.m_20388_(f);
    }

    @Override
    public double m_6048_() {
        return this.m_20192_();
    }

    private void spawnWithCreeper(ServerLevelAccessor level, DifficultyInstance difficulty) {
        Creeper creeper = (Creeper)EntityType.f_20558_.m_20615_((Level)level.m_6018_());
        if (creeper == null) {
            return;
        }
        creeper.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
        creeper.m_21530_();
        creeper.m_20329_((Entity)this);
        level.m_7967_((Entity)creeper);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.anchorPoint = this.m_20183_().m_6630_(5);
        this.setCreeperPhantomEntitySize(0);
        this.spawnWithCreeper(pLevel, pDifficulty);
        return super.finalizeSpawnForSons(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    protected float m_245547_(Player pPlayer) {
        float baseSpeed = 0.25f;
        float speedMultiplier = 1.0f;
        if (this.isBoosting()) {
            speedMultiplier = 4.0f;
        }
        return baseSpeed * speedMultiplier;
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class CreeperPhantomEntityMoveControl
    extends MoveControl {
        private float speed;

        public CreeperPhantomEntityMoveControl(Mob pMob) {
            super(pMob);
            this.speed = 0.1f;
        }

        public void m_8126_() {
            if (CreeperPhantomJockeyEntity.this.f_19862_) {
                CreeperPhantomJockeyEntity.this.m_146922_(CreeperPhantomJockeyEntity.this.m_146908_() + 180.0f);
                this.speed = 0.1f;
            }
            double d0 = CreeperPhantomJockeyEntity.this.moveTargetPoint.f_82479_ - CreeperPhantomJockeyEntity.this.m_20185_();
            double d1 = CreeperPhantomJockeyEntity.this.moveTargetPoint.f_82480_ - CreeperPhantomJockeyEntity.this.m_20186_();
            double d2 = CreeperPhantomJockeyEntity.this.moveTargetPoint.f_82481_ - CreeperPhantomJockeyEntity.this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = CreeperPhantomJockeyEntity.this.m_146908_();
                float f1 = (float)Mth.m_14136_((double)d2, (double)d0);
                float f2 = Mth.m_14177_((float)(CreeperPhantomJockeyEntity.this.m_146908_() + 90.0f));
                float f3 = Mth.m_14177_((float)(f1 * 57.295776f));
                CreeperPhantomJockeyEntity.this.m_146922_(Mth.m_14148_((float)f2, (float)f3, (float)4.0f) - 90.0f);
                CreeperPhantomJockeyEntity.this.f_20883_ = CreeperPhantomJockeyEntity.this.m_146908_();
                this.speed = Mth.m_14145_((float)f, (float)CreeperPhantomJockeyEntity.this.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.2f, (float)0.025f);
                float f4 = (float)(-(Mth.m_14136_((double)(-d1), (double)d3) * 57.2957763671875));
                CreeperPhantomJockeyEntity.this.m_146926_(f4);
                float f5 = CreeperPhantomJockeyEntity.this.m_146908_() + 90.0f;
                double d6 = (double)(this.speed * Mth.m_14089_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.m_14031_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.m_14031_((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = CreeperPhantomJockeyEntity.this.m_20184_();
                CreeperPhantomJockeyEntity.this.m_20256_(vec3.m_82549_(new Vec3(d6, d8, d7).m_82546_(vec3).m_82490_(0.2)));
            }
        }
    }

    class CreeperPhantomEntityLookControl
    extends LookControl {
        public CreeperPhantomEntityLookControl(Mob pMob) {
            super(pMob);
        }

        public void m_8128_() {
        }
    }

    class CreeperPhantomEntityBodyRotationControl
    extends BodyRotationControl {
        public CreeperPhantomEntityBodyRotationControl(Mob pMob) {
            super(pMob);
        }

        public void m_8121_() {
            CreeperPhantomJockeyEntity.this.f_20885_ = CreeperPhantomJockeyEntity.this.f_20883_;
            CreeperPhantomJockeyEntity.this.f_20883_ = CreeperPhantomJockeyEntity.this.m_146908_();
        }
    }

    class CreeperPhantomEntityAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        CreeperPhantomEntityAttackStrategyGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = CreeperPhantomJockeyEntity.this.m_5448_();
            return livingentity != null ? CreeperPhantomJockeyEntity.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }

        public void m_8056_() {
            this.nextSweepTick = this.m_183277_(10);
            CreeperPhantomJockeyEntity.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void m_8041_() {
            CreeperPhantomJockeyEntity.this.anchorPoint = CreeperPhantomJockeyEntity.this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, CreeperPhantomJockeyEntity.this.anchorPoint).m_6630_(10 + CreeperPhantomJockeyEntity.this.f_19796_.m_188503_(20));
        }

        public void m_8037_() {
            if (CreeperPhantomJockeyEntity.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    CreeperPhantomJockeyEntity.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.m_183277_((8 + CreeperPhantomJockeyEntity.this.f_19796_.m_188503_(4)) * 20);
                    CreeperPhantomJockeyEntity.this.m_5496_(SoundEvents.f_12232_, 10.0f, 0.95f + CreeperPhantomJockeyEntity.this.f_19796_.m_188501_() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            CreeperPhantomJockeyEntity.this.anchorPoint = CreeperPhantomJockeyEntity.this.m_5448_().m_20183_().m_6630_(20 + CreeperPhantomJockeyEntity.this.f_19796_.m_188503_(20));
            if (CreeperPhantomJockeyEntity.this.anchorPoint.m_123342_() < CreeperPhantomJockeyEntity.this.m_9236_().m_5736_()) {
                CreeperPhantomJockeyEntity.this.anchorPoint = new BlockPos(CreeperPhantomJockeyEntity.this.anchorPoint.m_123341_(), CreeperPhantomJockeyEntity.this.m_9236_().m_5736_() + 1, CreeperPhantomJockeyEntity.this.anchorPoint.m_123343_());
            }
        }
    }

    class CreeperPhantomEntitySweepAttackGoal
    extends CreeperPhantomEntityMoveTargetGoal {
        private static final int CAT_SEARCH_TICK_DELAY = 20;
        private boolean isScaredOfCat;
        private int catSearchTick;

        CreeperPhantomEntitySweepAttackGoal() {
        }

        public boolean m_8036_() {
            return CreeperPhantomJockeyEntity.this.m_5448_() != null && CreeperPhantomJockeyEntity.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = CreeperPhantomJockeyEntity.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player) {
                Player player = (Player)livingentity;
                if (livingentity.m_5833_() || player.m_7500_()) {
                    return false;
                }
            }
            if (!this.m_8036_()) {
                return false;
            }
            if (CreeperPhantomJockeyEntity.this.f_19797_ > this.catSearchTick) {
                this.catSearchTick = CreeperPhantomJockeyEntity.this.f_19797_ + 20;
                List list = CreeperPhantomJockeyEntity.this.m_9236_().m_6443_(Cat.class, CreeperPhantomJockeyEntity.this.m_20191_().m_82400_(16.0), EntitySelector.f_20402_);
                for (Cat cat : list) {
                    cat.m_28167_();
                }
                this.isScaredOfCat = !list.isEmpty();
            }
            return !this.isScaredOfCat;
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            CreeperPhantomJockeyEntity.this.m_6710_(null);
            CreeperPhantomJockeyEntity.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity livingentity = CreeperPhantomJockeyEntity.this.m_5448_();
            if (livingentity != null) {
                CreeperPhantomJockeyEntity.this.moveTargetPoint = new Vec3(livingentity.m_20185_(), livingentity.m_20227_(0.5), livingentity.m_20189_());
                if (CreeperPhantomJockeyEntity.this.m_20191_().m_82400_((double)-0.1f).m_82381_(livingentity.m_20191_())) {
                    if (!CreeperPhantomJockeyEntity.this.m_9236_().f_46443_) {
                        boolean hasCreeperPassenger = CreeperPhantomJockeyEntity.this.m_20197_().stream().anyMatch(passenger -> passenger instanceof Creeper);
                        if (hasCreeperPassenger) {
                            CreeperPhantomJockeyEntity.this.m_9236_().m_255391_((Entity)CreeperPhantomJockeyEntity.this, livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 3.0f, false, Level.ExplosionInteraction.MOB);
                            CreeperPhantomJockeyEntity.this.m_6074_();
                        } else {
                            CreeperPhantomJockeyEntity.this.m_7327_((Entity)livingentity);
                        }
                    }
                    CreeperPhantomJockeyEntity.this.attackPhase = AttackPhase.CIRCLE;
                    if (!CreeperPhantomJockeyEntity.this.m_20067_()) {
                        CreeperPhantomJockeyEntity.this.m_9236_().m_46796_(1039, CreeperPhantomJockeyEntity.this.m_20183_(), 0);
                    }
                } else if (CreeperPhantomJockeyEntity.this.f_19862_ || CreeperPhantomJockeyEntity.this.f_20916_ > 0) {
                    CreeperPhantomJockeyEntity.this.attackPhase = AttackPhase.CIRCLE;
                }
            }
        }
    }

    class CreeperPhantomEntityCircleAroundAnchorGoal
    extends CreeperPhantomEntityMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        CreeperPhantomEntityCircleAroundAnchorGoal() {
        }

        public boolean m_8036_() {
            return CreeperPhantomJockeyEntity.this.m_5448_() == null || CreeperPhantomJockeyEntity.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void m_8056_() {
            this.distance = 5.0f + CreeperPhantomJockeyEntity.this.f_19796_.m_188501_() * 10.0f;
            this.height = -4.0f + CreeperPhantomJockeyEntity.this.f_19796_.m_188501_() * 9.0f;
            this.clockwise = CreeperPhantomJockeyEntity.this.f_19796_.m_188499_() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void m_8037_() {
            if (CreeperPhantomJockeyEntity.this.f_19796_.m_188503_(this.m_183277_(350)) == 0) {
                this.height = -4.0f + CreeperPhantomJockeyEntity.this.f_19796_.m_188501_() * 9.0f;
            }
            if (CreeperPhantomJockeyEntity.this.f_19796_.m_188503_(this.m_183277_(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (CreeperPhantomJockeyEntity.this.f_19796_.m_188503_(this.m_183277_(450)) == 0) {
                this.angle = CreeperPhantomJockeyEntity.this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (CreeperPhantomJockeyEntity.this.moveTargetPoint.f_82480_ < CreeperPhantomJockeyEntity.this.m_20186_() && !CreeperPhantomJockeyEntity.this.m_9236_().m_46859_(CreeperPhantomJockeyEntity.this.m_20183_().m_6625_(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (CreeperPhantomJockeyEntity.this.moveTargetPoint.f_82480_ > CreeperPhantomJockeyEntity.this.m_20186_() && !CreeperPhantomJockeyEntity.this.m_9236_().m_46859_(CreeperPhantomJockeyEntity.this.m_20183_().m_6630_(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.f_121853_.equals((Object)CreeperPhantomJockeyEntity.this.anchorPoint)) {
                CreeperPhantomJockeyEntity.this.anchorPoint = CreeperPhantomJockeyEntity.this.m_20183_();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            CreeperPhantomJockeyEntity.this.moveTargetPoint = Vec3.m_82528_((Vec3i)CreeperPhantomJockeyEntity.this.anchorPoint).m_82520_((double)(this.distance * Mth.m_14089_((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.m_14031_((float)this.angle)));
        }
    }

    class CreeperPhantomEntityAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
        private int nextScanTick = CreeperPhantomEntityAttackPlayerTargetGoal.m_186073_((int)20);

        CreeperPhantomEntityAttackPlayerTargetGoal() {
        }

        public boolean m_8036_() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = CreeperPhantomEntityAttackPlayerTargetGoal.m_186073_((int)60);
            List list = CreeperPhantomJockeyEntity.this.m_9236_().m_45955_(this.attackTargeting, (LivingEntity)CreeperPhantomJockeyEntity.this, CreeperPhantomJockeyEntity.this.m_20191_().m_82377_(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(Entity::m_20186_).reversed());
                for (Player player : list) {
                    if (!CreeperPhantomJockeyEntity.this.m_21040_((LivingEntity)player, TargetingConditions.f_26872_)) continue;
                    CreeperPhantomJockeyEntity.this.m_6710_((LivingEntity)player);
                    return true;
                }
            }
            return false;
        }

        public void m_8037_() {
            Player player;
            LivingEntity target = CreeperPhantomJockeyEntity.this.m_5448_();
            if (target instanceof Player && (player = (Player)target).m_20202_() == CreeperPhantomJockeyEntity.this) {
                CreeperPhantomJockeyEntity.this.m_6710_(null);
            }
        }

        public boolean m_8045_() {
            LivingEntity livingentity = CreeperPhantomJockeyEntity.this.m_5448_();
            return livingentity != null ? CreeperPhantomJockeyEntity.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }
    }

    abstract class CreeperPhantomEntityMoveTargetGoal
    extends Goal {
        protected boolean touchingTarget() {
            return CreeperPhantomJockeyEntity.this.moveTargetPoint.m_82531_(CreeperPhantomJockeyEntity.this.m_20185_(), CreeperPhantomJockeyEntity.this.m_20186_(), CreeperPhantomJockeyEntity.this.m_20189_()) < 1.0;
        }
    }
}

