/*
 * Decompiled with CFR 0.152.
 */
package net.sven.svens_phantom_jockeys.entity.custom;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.sven.svens_phantom_jockeys.item.ModItems;

public class SkeletonPhantomJockeyEntity
extends FlyingMob
implements PlayerRideable,
ItemSteerable,
Saddleable {
    public static final float FLAP_DEGREES_PER_TICK = 7.448451f;
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)24.166098f);
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(SkeletonPhantomJockeyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    Vec3 moveTargetPoint = Vec3.f_82478_;
    BlockPos anchorPoint = BlockPos.f_121853_;
    AttackPhase attackPhase = AttackPhase.CIRCLE;
    private int useItemTime = 0;
    private static final EntityDataAccessor<Boolean> DATA_SADDLE_ID = SynchedEntityData.m_135353_(SkeletonPhantomJockeyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_BOOST_TIME = SynchedEntityData.m_135353_(SkeletonPhantomJockeyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_BOOSTING = SynchedEntityData.m_135353_(SkeletonPhantomJockeyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int boostCooldown = 0;
    private final ItemBasedSteering steering = new ItemBasedSteering(this.f_19804_, DATA_BOOST_TIME, DATA_SADDLE_ID);

    public SkeletonPhantomJockeyEntity(EntityType<? extends SkeletonPhantomJockeyEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 5;
        this.f_21342_ = new SkeletonPhantomEntityMoveControl((Mob)this);
        this.f_21365_ = new SkeletonPhantomEntityLookControl((Mob)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FlyingMob.m_21183_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.5).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 2.0);
    }

    public boolean m_142039_() {
        return (this.getUniqueFlapTickOffset() + this.f_19797_) % TICKS_PER_FLAP == 0;
    }

    protected BodyRotationControl m_7560_() {
        return new SkeletonPhantomEntityBodyRotationControl((Mob)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SkeletonPhantomEntityAttackStrategyGoal());
        this.f_21345_.m_25352_(2, (Goal)new SkeletonPhantomEntitySweepAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new SkeletonPhantomEntityCircleAroundAnchorGoal());
        this.f_21346_.m_25352_(1, (Goal)new SkeletonPhantomEntityAttackPlayerTargetGoal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SIZE, (Object)0);
        this.f_19804_.m_135372_(DATA_SADDLE_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_BOOST_TIME, (Object)0);
        this.f_19804_.m_135372_(DATA_BOOSTING, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (ID_SIZE.equals(pKey)) {
            this.updateSkeletonPhantomEntitySizeInfo();
        }
        if (DATA_BOOSTING.equals(pKey) && this.isBoosting() && this.m_9236_().f_46443_) {
            this.playBoostSound();
        }
        super.m_7350_(pKey);
    }

    private void playBoostSound() {
        this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12228_, SoundSource.NEUTRAL, 0.5f, 1.2f, false);
    }

    public void setSkeletonPhantomEntitySize(int pSkeletonPhantomEntitySize) {
        this.f_19804_.m_135381_(ID_SIZE, (Object)Mth.m_14045_((int)pSkeletonPhantomEntitySize, (int)0, (int)64));
    }

    private void updateSkeletonPhantomEntitySizeInfo() {
        this.m_6210_();
        this.m_21051_(Attributes.f_22281_).m_22100_((double)(6 + this.getSkeletonPhantomEntitySize()));
    }

    public int getSkeletonPhantomEntitySize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.35f;
    }

    public int getUniqueFlapTickOffset() {
        return this.m_19879_() * 3;
    }

    protected boolean m_8028_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            float f = Mth.m_14089_((float)((float)(this.getUniqueFlapTickOffset() + this.f_19797_) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            float f1 = Mth.m_14089_((float)((float)(this.getUniqueFlapTickOffset() + this.f_19797_ + 1) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12230_, this.m_5720_(), 0.95f + this.f_19796_.m_188501_() * 0.05f, 0.95f + this.f_19796_.m_188501_() * 0.05f, false);
            }
            int i = this.getSkeletonPhantomEntitySize();
            float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f4 = (0.3f + f * 0.45f) * ((float)i * 0.2f + 1.0f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() + (double)f2, this.m_20186_() + (double)f4, this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() - (double)f2, this.m_20186_() + (double)f4, this.m_20189_() - (double)f3, 0.0, 0.0, 0.0);
        }
    }

    public void m_8107_() {
        if (this.m_6084_() && this.m_21527_()) {
            this.m_20254_(8);
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        super.m_8024_();
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("AX")) {
            this.anchorPoint = new BlockPos(pCompound.m_128451_("AX"), pCompound.m_128451_("AY"), pCompound.m_128451_("AZ"));
        }
        this.setSkeletonPhantomEntitySize(pCompound.m_128451_("Size"));
        this.steering.m_20852_(pCompound);
        this.setBoosting(pCompound.m_128471_("Boosting"));
        this.setBoostTime(pCompound.m_128451_("BoostTime"));
        this.boostCooldown = pCompound.m_128451_("BoostCooldown");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("AX", this.anchorPoint.m_123341_());
        pCompound.m_128405_("AY", this.anchorPoint.m_123342_());
        pCompound.m_128405_("AZ", this.anchorPoint.m_123343_());
        pCompound.m_128405_("Size", this.getSkeletonPhantomEntitySize());
        this.steering.m_20847_(pCompound);
        pCompound.m_128379_("Boosting", this.isBoosting());
        pCompound.m_128405_("BoostTime", this.getBoostTime());
        pCompound.m_128405_("BoostCooldown", this.boostCooldown);
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12227_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12231_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12229_;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public boolean m_6549_(EntityType<?> pType) {
        return true;
    }

    public EntityDimensions m_6972_(Pose pPose) {
        int i = this.getSkeletonPhantomEntitySize();
        EntityDimensions entitydimensions = super.m_6972_(pPose);
        float f = (entitydimensions.f_20377_ + 0.2f * (float)i) / entitydimensions.f_20377_;
        return entitydimensions.m_20388_(f);
    }

    public double m_6048_() {
        return this.m_20192_();
    }

    public boolean m_6746_() {
        return false;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (this.m_6254_() && !this.m_20160_() && !pPlayer.m_36341_()) {
            if (!this.m_9236_().f_46443_) {
                pPlayer.m_20329_((Entity)this);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        InteractionResult interactionresult = super.m_6071_(pPlayer, pHand);
        if (!interactionresult.m_19077_()) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            return itemstack.m_150930_(Items.f_42450_) ? itemstack.m_41647_(pPlayer, (LivingEntity)this, pHand) : InteractionResult.PASS;
        }
        return interactionresult;
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_();
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    public boolean m_6254_() {
        return this.steering.m_20851_();
    }

    public void m_5853_(@Nullable SoundSource pSource) {
        this.steering.m_20849_(true);
        if (pSource != null) {
            this.m_9236_().m_6269_((Player)null, (Entity)this, SoundEvents.f_12236_, pSource, 0.5f, 1.0f);
        }
    }

    private void spawnWithSkeletonRider(ServerLevelAccessor level, DifficultyInstance difficulty) {
        Skeleton skeleton = (Skeleton)EntityType.f_20524_.m_20615_((Level)level.m_6018_());
        if (skeleton == null) {
            return;
        }
        skeleton.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
        skeleton.m_21530_();
        skeleton.m_6518_((ServerLevelAccessor)this.m_9236_(), this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.EVENT, (SpawnGroupData)null, (CompoundTag)null);
        skeleton.m_20329_((Entity)this);
        this.equipSkeleton(skeleton, level.m_213780_(), difficulty);
        level.m_7967_((Entity)skeleton);
    }

    private void equipSkeleton(Skeleton skeleton, RandomSource random, DifficultyInstance difficulty) {
        skeleton.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        if (random.m_188501_() < 0.5f) {
            this.equipWithArmor(skeleton, random, difficulty);
        }
    }

    private void equipWithArmor(Skeleton skeleton, RandomSource random, DifficultyInstance difficulty) {
        float chance = difficulty.m_19057_();
        if (random.m_188501_() < 0.15f * chance) {
            skeleton.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42468_));
            skeleton.m_21409_(EquipmentSlot.HEAD, 0.0f);
        }
        if (random.m_188501_() < 0.12f * chance) {
            skeleton.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
            skeleton.m_21409_(EquipmentSlot.CHEST, 0.0f);
        }
        if (random.m_188501_() < 0.1f * chance) {
            skeleton.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42470_));
            skeleton.m_21409_(EquipmentSlot.LEGS, 0.0f);
        }
        if (random.m_188501_() < 0.08f * chance) {
            skeleton.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
            skeleton.m_21409_(EquipmentSlot.FEET, 0.0f);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.anchorPoint = this.m_20183_().m_6630_(5);
        this.setSkeletonPhantomEntitySize(0);
        this.spawnWithSkeletonRider(pLevel, pDifficulty);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public SpawnGroupData finalizeSpawnForSons(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_274498_(Player pPlayer, Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        this.m_19915_(pPlayer.m_146908_(), pPlayer.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        this.steering.m_274606_();
        this.updateBoostState();
    }

    protected Vec3 m_274312_(Player pPlayer, Vec3 pTravelVector) {
        float pitch = pPlayer.m_146909_();
        double verticalMovement = 0.0;
        if (pitch < -5.0f) {
            verticalMovement = 0.5;
        } else if (pitch > 35.0f) {
            verticalMovement = -0.5;
        }
        return new Vec3(0.0, verticalMovement, 1.0);
    }

    protected float m_245547_(Player pPlayer) {
        float baseSpeed = 0.4f;
        float speedMultiplier = 1.0f;
        if (this.isBoosting()) {
            speedMultiplier = 2.0f;
        }
        return baseSpeed * speedMultiplier;
    }

    public LivingEntity m_6688_() {
        Player player;
        Entity entity;
        if (this.m_6254_() && (entity = this.m_146895_()) instanceof Player && ((player = (Player)entity).m_21205_().m_150930_((Item)ModItems.CLOCK_ON_A_STICK.get()) || player.m_21206_().m_150930_((Item)ModItems.CLOCK_ON_A_STICK.get()))) {
            return player;
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity pLivingEntity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(pLivingEntity);
        }
        int[][] aint = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockpos = this.m_20183_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Pose pose : pLivingEntity.m_7431_()) {
            AABB aabb = pLivingEntity.m_21270_(pose);
            for (int[] aint1 : aint) {
                blockpos$mutableblockpos.m_122178_(blockpos.m_123341_() + aint1[0], blockpos.m_123342_(), blockpos.m_123343_() + aint1[1]);
                double d0 = this.m_9236_().m_45573_((BlockPos)blockpos$mutableblockpos);
                if (!DismountHelper.m_38439_((double)d0)) continue;
                Vec3 vec3 = Vec3.m_82514_((Vec3i)blockpos$mutableblockpos, (double)d0);
                if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)pLivingEntity, (AABB)aabb.m_82383_(vec3))) continue;
                pLivingEntity.m_20124_(pose);
                return vec3;
            }
        }
        return super.m_7688_(pLivingEntity);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            this.handlePlayerControlledMovement(travelVector);
            return;
        }
        super.m_7023_(travelVector);
    }

    private void handlePlayerControlledMovement(Vec3 travelVector) {
        Player player = (Player)this.m_6688_();
        Vec3 lookDirection = player.m_20154_();
        float speed = this.m_245547_(player);
        Vec3 rawInput = this.m_274312_(player, travelVector);
        Vec3 movement = new Vec3(lookDirection.f_82479_ * rawInput.f_82481_ * (double)speed, rawInput.f_82480_ * (double)speed, lookDirection.f_82481_ * rawInput.f_82481_ * (double)speed);
        this.m_20256_(movement);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_267651_(true);
        this.m_19915_(player.m_146908_(), player.m_146909_() * 0.5f);
    }

    public void triggerBoost(Player player, ItemStack itemStack) {
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return;
        }
        this.setBoosting(true);
        this.setBoostTime(60);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12228_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public boolean isBoosting() {
        return (Boolean)this.f_19804_.m_135370_(DATA_BOOSTING);
    }

    public void setBoosting(boolean boosting) {
        this.f_19804_.m_135381_(DATA_BOOSTING, (Object)boosting);
    }

    public int getBoostTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_BOOST_TIME);
    }

    public void setBoostTime(int time) {
        this.f_19804_.m_135381_(DATA_BOOST_TIME, (Object)time);
    }

    private void updateBoostState() {
        if (this.isBoosting()) {
            int boostTime = this.getBoostTime() - 1;
            this.setBoostTime(boostTime);
            if (this.m_9236_().f_46443_ && this.f_19797_ % 5 == 0) {
                this.spawnBoostParticles();
            }
            if (boostTime <= 0) {
                this.setBoosting(false);
                this.setBoostTime(0);
            }
        }
    }

    private void spawnBoostParticles() {
        for (int i = 0; i < 3; ++i) {
            double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double y = this.m_20186_() + this.f_19796_.m_188500_() * 1.5;
            double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class SkeletonPhantomEntityMoveControl
    extends MoveControl {
        private float speed;

        public SkeletonPhantomEntityMoveControl(Mob pMob) {
            super(pMob);
            this.speed = 0.1f;
        }

        public void m_8126_() {
            if (SkeletonPhantomJockeyEntity.this.f_19862_) {
                SkeletonPhantomJockeyEntity.this.m_146922_(SkeletonPhantomJockeyEntity.this.m_146908_() + 180.0f);
                this.speed = 0.1f;
            }
            double d0 = SkeletonPhantomJockeyEntity.this.moveTargetPoint.f_82479_ - SkeletonPhantomJockeyEntity.this.m_20185_();
            double d1 = SkeletonPhantomJockeyEntity.this.moveTargetPoint.f_82480_ - SkeletonPhantomJockeyEntity.this.m_20186_();
            double d2 = SkeletonPhantomJockeyEntity.this.moveTargetPoint.f_82481_ - SkeletonPhantomJockeyEntity.this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = SkeletonPhantomJockeyEntity.this.m_146908_();
                float f1 = (float)Mth.m_14136_((double)d2, (double)d0);
                float f2 = Mth.m_14177_((float)(SkeletonPhantomJockeyEntity.this.m_146908_() + 90.0f));
                float f3 = Mth.m_14177_((float)(f1 * 57.295776f));
                SkeletonPhantomJockeyEntity.this.m_146922_(Mth.m_14148_((float)f2, (float)f3, (float)4.0f) - 90.0f);
                SkeletonPhantomJockeyEntity.this.f_20883_ = SkeletonPhantomJockeyEntity.this.m_146908_();
                this.speed = Mth.m_14145_((float)f, (float)SkeletonPhantomJockeyEntity.this.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.2f, (float)0.025f);
                float f4 = (float)(-(Mth.m_14136_((double)(-d1), (double)d3) * 57.2957763671875));
                SkeletonPhantomJockeyEntity.this.m_146926_(f4);
                float f5 = SkeletonPhantomJockeyEntity.this.m_146908_() + 90.0f;
                double d6 = (double)(this.speed * Mth.m_14089_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.m_14031_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.m_14031_((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = SkeletonPhantomJockeyEntity.this.m_20184_();
                SkeletonPhantomJockeyEntity.this.m_20256_(vec3.m_82549_(new Vec3(d6, d8, d7).m_82546_(vec3).m_82490_(0.2)));
            }
        }
    }

    class SkeletonPhantomEntityLookControl
    extends LookControl {
        public SkeletonPhantomEntityLookControl(Mob pMob) {
            super(pMob);
        }

        public void m_8128_() {
        }
    }

    class SkeletonPhantomEntityBodyRotationControl
    extends BodyRotationControl {
        public SkeletonPhantomEntityBodyRotationControl(Mob pMob) {
            super(pMob);
        }

        public void m_8121_() {
            SkeletonPhantomJockeyEntity.this.f_20885_ = SkeletonPhantomJockeyEntity.this.f_20883_;
            SkeletonPhantomJockeyEntity.this.f_20883_ = SkeletonPhantomJockeyEntity.this.m_146908_();
        }
    }

    class SkeletonPhantomEntityAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        SkeletonPhantomEntityAttackStrategyGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = SkeletonPhantomJockeyEntity.this.m_5448_();
            return livingentity != null ? SkeletonPhantomJockeyEntity.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }

        public void m_8056_() {
            this.nextSweepTick = this.m_183277_(10);
            SkeletonPhantomJockeyEntity.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void m_8041_() {
            SkeletonPhantomJockeyEntity.this.anchorPoint = SkeletonPhantomJockeyEntity.this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, SkeletonPhantomJockeyEntity.this.anchorPoint).m_6630_(10 + SkeletonPhantomJockeyEntity.this.f_19796_.m_188503_(20));
        }

        public void m_8037_() {
            if (SkeletonPhantomJockeyEntity.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    SkeletonPhantomJockeyEntity.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.m_183277_((8 + SkeletonPhantomJockeyEntity.this.f_19796_.m_188503_(4)) * 20);
                    SkeletonPhantomJockeyEntity.this.m_5496_(SoundEvents.f_12232_, 10.0f, 0.95f + SkeletonPhantomJockeyEntity.this.f_19796_.m_188501_() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            SkeletonPhantomJockeyEntity.this.anchorPoint = SkeletonPhantomJockeyEntity.this.m_5448_().m_20183_().m_6630_(20 + SkeletonPhantomJockeyEntity.this.f_19796_.m_188503_(20));
            if (SkeletonPhantomJockeyEntity.this.anchorPoint.m_123342_() < SkeletonPhantomJockeyEntity.this.m_9236_().m_5736_()) {
                SkeletonPhantomJockeyEntity.this.anchorPoint = new BlockPos(SkeletonPhantomJockeyEntity.this.anchorPoint.m_123341_(), SkeletonPhantomJockeyEntity.this.m_9236_().m_5736_() + 1, SkeletonPhantomJockeyEntity.this.anchorPoint.m_123343_());
            }
        }
    }

    class SkeletonPhantomEntitySweepAttackGoal
    extends SkeletonPhantomEntityMoveTargetGoal {
        private static final int CAT_SEARCH_TICK_DELAY = 20;
        private boolean isScaredOfCat;
        private int catSearchTick;

        SkeletonPhantomEntitySweepAttackGoal() {
        }

        public boolean m_8036_() {
            return SkeletonPhantomJockeyEntity.this.m_5448_() != null && SkeletonPhantomJockeyEntity.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = SkeletonPhantomJockeyEntity.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player) {
                Player player = (Player)livingentity;
                if (livingentity.m_5833_() || player.m_7500_()) {
                    return false;
                }
            }
            if (!this.m_8036_()) {
                return false;
            }
            if (SkeletonPhantomJockeyEntity.this.f_19797_ > this.catSearchTick) {
                this.catSearchTick = SkeletonPhantomJockeyEntity.this.f_19797_ + 20;
                List list = SkeletonPhantomJockeyEntity.this.m_9236_().m_6443_(Cat.class, SkeletonPhantomJockeyEntity.this.m_20191_().m_82400_(16.0), EntitySelector.f_20402_);
                for (Cat cat : list) {
                    cat.m_28167_();
                }
                this.isScaredOfCat = !list.isEmpty();
            }
            return !this.isScaredOfCat;
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            SkeletonPhantomJockeyEntity.this.m_6710_(null);
            SkeletonPhantomJockeyEntity.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity livingentity = SkeletonPhantomJockeyEntity.this.m_5448_();
            if (livingentity != null) {
                SkeletonPhantomJockeyEntity.this.moveTargetPoint = new Vec3(livingentity.m_20185_(), livingentity.m_20227_(0.5), livingentity.m_20189_());
                if (SkeletonPhantomJockeyEntity.this.m_20191_().m_82400_((double)-0.1f).m_82381_(livingentity.m_20191_())) {
                    SkeletonPhantomJockeyEntity.this.m_7327_((Entity)livingentity);
                    SkeletonPhantomJockeyEntity.this.attackPhase = AttackPhase.CIRCLE;
                    if (!SkeletonPhantomJockeyEntity.this.m_20067_()) {
                        SkeletonPhantomJockeyEntity.this.m_9236_().m_46796_(1039, SkeletonPhantomJockeyEntity.this.m_20183_(), 0);
                    }
                } else if (SkeletonPhantomJockeyEntity.this.f_19862_ || SkeletonPhantomJockeyEntity.this.f_20916_ > 0) {
                    SkeletonPhantomJockeyEntity.this.attackPhase = AttackPhase.CIRCLE;
                }
            }
        }
    }

    class SkeletonPhantomEntityCircleAroundAnchorGoal
    extends SkeletonPhantomEntityMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        SkeletonPhantomEntityCircleAroundAnchorGoal() {
        }

        public boolean m_8036_() {
            return SkeletonPhantomJockeyEntity.this.m_5448_() == null || SkeletonPhantomJockeyEntity.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void m_8056_() {
            this.distance = 5.0f + SkeletonPhantomJockeyEntity.this.f_19796_.m_188501_() * 10.0f;
            this.height = -4.0f + SkeletonPhantomJockeyEntity.this.f_19796_.m_188501_() * 9.0f;
            this.clockwise = SkeletonPhantomJockeyEntity.this.f_19796_.m_188499_() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void m_8037_() {
            if (SkeletonPhantomJockeyEntity.this.f_19796_.m_188503_(this.m_183277_(350)) == 0) {
                this.height = -4.0f + SkeletonPhantomJockeyEntity.this.f_19796_.m_188501_() * 9.0f;
            }
            if (SkeletonPhantomJockeyEntity.this.f_19796_.m_188503_(this.m_183277_(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (SkeletonPhantomJockeyEntity.this.f_19796_.m_188503_(this.m_183277_(450)) == 0) {
                this.angle = SkeletonPhantomJockeyEntity.this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (SkeletonPhantomJockeyEntity.this.moveTargetPoint.f_82480_ < SkeletonPhantomJockeyEntity.this.m_20186_() && !SkeletonPhantomJockeyEntity.this.m_9236_().m_46859_(SkeletonPhantomJockeyEntity.this.m_20183_().m_6625_(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (SkeletonPhantomJockeyEntity.this.moveTargetPoint.f_82480_ > SkeletonPhantomJockeyEntity.this.m_20186_() && !SkeletonPhantomJockeyEntity.this.m_9236_().m_46859_(SkeletonPhantomJockeyEntity.this.m_20183_().m_6630_(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.f_121853_.equals((Object)SkeletonPhantomJockeyEntity.this.anchorPoint)) {
                SkeletonPhantomJockeyEntity.this.anchorPoint = SkeletonPhantomJockeyEntity.this.m_20183_();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            SkeletonPhantomJockeyEntity.this.moveTargetPoint = Vec3.m_82528_((Vec3i)SkeletonPhantomJockeyEntity.this.anchorPoint).m_82520_((double)(this.distance * Mth.m_14089_((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.m_14031_((float)this.angle)));
        }
    }

    class SkeletonPhantomEntityAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
        private int nextScanTick = SkeletonPhantomEntityAttackPlayerTargetGoal.m_186073_((int)20);

        SkeletonPhantomEntityAttackPlayerTargetGoal() {
        }

        public boolean m_8036_() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = SkeletonPhantomEntityAttackPlayerTargetGoal.m_186073_((int)60);
            List list = SkeletonPhantomJockeyEntity.this.m_9236_().m_45955_(this.attackTargeting, (LivingEntity)SkeletonPhantomJockeyEntity.this, SkeletonPhantomJockeyEntity.this.m_20191_().m_82377_(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(Entity::m_20186_).reversed());
                for (Player player : list) {
                    if (!SkeletonPhantomJockeyEntity.this.m_21040_((LivingEntity)player, TargetingConditions.f_26872_)) continue;
                    SkeletonPhantomJockeyEntity.this.m_6710_((LivingEntity)player);
                    return true;
                }
            }
            return false;
        }

        public void m_8037_() {
            Player player;
            LivingEntity target = SkeletonPhantomJockeyEntity.this.m_5448_();
            if (target instanceof Player && (player = (Player)target).m_20202_() == SkeletonPhantomJockeyEntity.this) {
                SkeletonPhantomJockeyEntity.this.m_6710_(null);
            }
        }

        public boolean m_8045_() {
            LivingEntity livingentity = SkeletonPhantomJockeyEntity.this.m_5448_();
            return livingentity != null ? SkeletonPhantomJockeyEntity.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }
    }

    abstract class SkeletonPhantomEntityMoveTargetGoal
    extends Goal {
        protected boolean touchingTarget() {
            return SkeletonPhantomJockeyEntity.this.moveTargetPoint.m_82531_(SkeletonPhantomJockeyEntity.this.m_20185_(), SkeletonPhantomJockeyEntity.this.m_20186_(), SkeletonPhantomJockeyEntity.this.m_20189_()) < 1.0;
        }
    }
}

