/*
 * Decompiled with CFR 0.152.
 */
package net.sven.svens_phantom_jockeys.event;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.sven.svens_phantom_jockeys.entity.custom.CreeperPhantomJockeyEntity;
import net.sven.svens_phantom_jockeys.entity.custom.SkeletonPhantomJockeyEntity;
import net.sven.svens_phantom_jockeys.entity.custom.ZombiePhantomJockeyEntity;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ModEvents {
    @SubscribeEvent
    public static void onEntityRenderPre(RenderLivingEvent.Pre<?, ?> event) {
        LivingEntity rider = event.getEntity();
        List<Class<ZombiePhantomJockeyEntity>> phantoms = List.of(SkeletonPhantomJockeyEntity.class, CreeperPhantomJockeyEntity.class, ZombiePhantomJockeyEntity.class);
        for (Class<ZombiePhantomJockeyEntity> phantomClass : phantoms) {
            Entity vehicle;
            if (!phantomClass.isInstance(rider.m_20202_()) || !((vehicle = rider.m_20202_()) instanceof LivingEntity)) continue;
            LivingEntity phantom = (LivingEntity)vehicle;
            ModEvents.syncRiderRotation(rider, phantom, event);
            break;
        }
    }

    private static void syncRiderRotation(LivingEntity rider, LivingEntity phantom, RenderLivingEvent.Pre<?, ?> event) {
        if (phantom instanceof SkeletonPhantomJockeyEntity || phantom instanceof CreeperPhantomJockeyEntity || phantom instanceof ZombiePhantomJockeyEntity) {
            rider.m_146922_(phantom.m_146908_());
            rider.f_19859_ = phantom.f_19859_;
            rider.f_20883_ = phantom.f_20883_;
            rider.f_20884_ = phantom.f_20884_;
            rider.f_20885_ = phantom.f_20885_;
            rider.f_20886_ = phantom.f_20886_;
            float pitchCompensation = ModEvents.calculatePitchCompensation(phantom.m_146909_());
            rider.m_146926_(pitchCompensation);
        }
    }

    private static float calculatePitchCompensation(float phantomPitch) {
        return phantomPitch * -0.4f;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        Level level = player.m_9236_();
        ItemStack stack = event.getItemStack();
        if (!level.f_46443_) {
            System.out.println("\u73a9\u5bb6\u53f3\u952e\u4e86\u7269\u54c1: " + stack.m_41720_().m_5524_());
            Entity entity = player.m_20202_();
            if (entity instanceof SkeletonPhantomJockeyEntity) {
                ItemStack usedItem;
                SkeletonPhantomJockeyEntity jockey = (SkeletonPhantomJockeyEntity)entity;
                if (player.m_6117_() && (usedItem = player.m_21211_()).m_150930_(Items.f_42685_)) {
                    if (!jockey.m_9236_().f_46443_) {
                        jockey.triggerBoost(player, usedItem);
                    }
                    player.m_5810_();
                }
            }
        }
    }
}

