/*
 * Decompiled with CFR 0.152.
 */
package cn.dancingsnow.disable_tools;

import cn.dancingsnow.disable_tools.TagBanConfig;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="tagban")
public class TagBanMod {
    public static final String MODID = "tagban";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static volatile List<Pattern> cachedBlacklistPatterns = Collections.emptyList();
    private static volatile List<Pattern> cachedWhitelistPatterns = Collections.emptyList();
    private static final Map<Item, Boolean> itemCache = new ConcurrentHashMap<Item, Boolean>();
    private static volatile long lastConfigReloadTime = 0L;
    private static final long CACHE_DURATION = 5000L;
    private static boolean clothConfigAvailable = false;

    public TagBanMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TagBanConfig.SPEC, "tagban.toml");
        modEventBus.addListener(this::onCommonSetup);
        if (clothConfigAvailable) {
            modEventBus.addListener(this::onClientSetup);
        }
        LOGGER.info("TagBan Mod \u5df2\u52a0\u8f7d / TagBan Mod loaded");
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            TagBanMod.compilePatterns();
            LOGGER.debug("\u5df2\u9884\u7f16\u8bd1 {} \u4e2a\u9ed1\u540d\u5355\u6a21\u5f0f\u548c {} \u4e2a\u767d\u540d\u5355\u6a21\u5f0f / Precompiled {} blacklist patterns and {} whitelist patterns", new Object[]{cachedBlacklistPatterns.size(), cachedWhitelistPatterns.size(), cachedBlacklistPatterns.size(), cachedWhitelistPatterns.size()});
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClientSetup(FMLClientSetupEvent event) {
        if (clothConfigAvailable) {
            event.enqueueWork(() -> {
                try {
                    ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> {
                        try {
                            return (Screen)Class.forName("cn.dancingsnow.disable_tools.TagBanConfigScreen").getMethod("create", Screen.class).invoke(null, parent);
                        }
                        catch (Exception e) {
                            LOGGER.error("\u65e0\u6cd5\u521b\u5efa\u914d\u7f6e\u754c\u9762 / Failed to create config screen", (Throwable)e);
                            return parent;
                        }
                    }));
                    LOGGER.info("\u914d\u7f6e\u754c\u9762\u5df2\u6ce8\u518c / Config screen registered");
                }
                catch (Exception e) {
                    LOGGER.error("\u6ce8\u518c\u914d\u7f6e\u754c\u9762\u65f6\u51fa\u9519 / Error registering config screen", (Throwable)e);
                }
            });
        }
    }

    private static void compilePatterns() {
        List blacklist = (List)TagBanConfig.INSTANCE.tools.get();
        List whitelist = (List)TagBanConfig.INSTANCE.whitelist.get();
        List newBlacklistPatterns = Collections.synchronizedList(new ArrayList(blacklist.size()));
        List newWhitelistPatterns = Collections.synchronizedList(new ArrayList(whitelist.size()));
        blacklist.parallelStream().forEach(regex -> {
            try {
                Pattern pattern = Pattern.compile(regex, 2);
                newBlacklistPatterns.add(pattern);
            }
            catch (Exception e) {
                LOGGER.error("\u65e0\u6548\u7684\u9ed1\u540d\u5355\u6b63\u5219\u8868\u8fbe\u5f0f: '{}', \u9519\u8bef: {} / Invalid blacklist regex: '{}', error: {}", new Object[]{regex, e.getMessage(), regex, e.getMessage()});
            }
        });
        whitelist.parallelStream().forEach(regex -> {
            try {
                Pattern pattern = Pattern.compile(regex, 2);
                newWhitelistPatterns.add(pattern);
            }
            catch (Exception e) {
                LOGGER.error("\u65e0\u6548\u7684\u767d\u540d\u5355\u6b63\u5219\u8868\u8fbe\u5f0f: '{}', \u9519\u8bef: {} / Invalid whitelist regex: '{}', error: {}", new Object[]{regex, e.getMessage(), regex, e.getMessage()});
            }
        });
        cachedBlacklistPatterns = new ArrayList<Pattern>(newBlacklistPatterns);
        cachedWhitelistPatterns = new ArrayList<Pattern>(newWhitelistPatterns);
        itemCache.clear();
        lastConfigReloadTime = System.currentTimeMillis();
        LOGGER.debug("\u6b63\u5219\u8868\u8fbe\u5f0f\u7f16\u8bd1\u5b8c\u6210 - \u9ed1\u540d\u5355: {} \u6761, \u767d\u540d\u5355: {} \u6761 / Regex compilation completed - blacklist: {}, whitelist: {}", new Object[]{cachedBlacklistPatterns.size(), cachedWhitelistPatterns.size(), cachedBlacklistPatterns.size(), cachedWhitelistPatterns.size()});
    }

    private static void checkAndRecompilePatterns() {
        if (cachedBlacklistPatterns.isEmpty() && cachedWhitelistPatterns.isEmpty() || System.currentTimeMillis() - lastConfigReloadTime > 5000L) {
            TagBanMod.compilePatterns();
        }
    }

    public static boolean isItemDisabled(Item item) {
        if (item == null) {
            return false;
        }
        Boolean cached = itemCache.get(item);
        if (cached != null) {
            return cached;
        }
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)item);
        if (key == null) {
            itemCache.put(item, false);
            return false;
        }
        String itemId = key.toString();
        TagBanMod.checkAndRecompilePatterns();
        for (Pattern pattern : cachedWhitelistPatterns) {
            if (!pattern.matcher(itemId).matches()) continue;
            itemCache.put(item, false);
            return false;
        }
        for (Pattern pattern : cachedBlacklistPatterns) {
            if (!pattern.matcher(itemId).matches()) continue;
            itemCache.put(item, true);
            return true;
        }
        itemCache.put(item, false);
        return false;
    }

    public static String getTooltipText() {
        return (String)TagBanConfig.INSTANCE.tooltip.get();
    }

    public static void reloadConfig() {
        new Thread(() -> {
            TagBanMod.compilePatterns();
            LOGGER.info("\u914d\u7f6e\u5df2\u91cd\u65b0\u52a0\u8f7d / Configuration reloaded");
        }, "TagBan-Config-Reload").start();
    }

    public static void clearCache() {
        itemCache.clear();
    }

    static {
        try {
            Class.forName("me.shedaniel.clothconfig2.api.ConfigBuilder");
            clothConfigAvailable = true;
            LOGGER.info("Cloth Config \u5df2\u68c0\u6d4b\u5230\uff0c\u914d\u7f6e\u754c\u9762\u53ef\u7528 / Cloth Config detected, config screen available");
        }
        catch (ClassNotFoundException e) {
            clothConfigAvailable = false;
            LOGGER.info("Cloth Config \u672a\u627e\u5230\uff0c\u914d\u7f6e\u754c\u9762\u5c06\u4e0d\u53ef\u7528 / Cloth Config not found, config screen unavailable");
        }
    }
}

