/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.tasks;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.serlith.purpur.PurpurBars;
import net.serlith.purpur.tasks.BossBarTask;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001cH\u0016J\b\u0010!\u001a\u00020\"H\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001e\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lnet/serlith/purpur/tasks/RamBarTask;", "Lnet/serlith/purpur/tasks/BossBarTask;", "plugin", "Lnet/serlith/purpur/PurpurBars;", "<init>", "(Lnet/serlith/purpur/PurpurBars;)V", "value", "", "allocated", "getAllocated", "()J", "used", "getUsed", "xmx", "getXmx", "xms", "getXms", "", "percent", "getPercent", "()F", "", "tick", "getTick", "()I", "createBossBar", "Lnet/kyori/adventure/bossbar/BossBar;", "updateBossBar", "", "bossbar", "player", "Lorg/bukkit/entity/Player;", "run", "getBossBarColor", "Lnet/kyori/adventure/bossbar/BossBar$Color;", "format", "Lnet/kyori/adventure/text/Component;", "v", "Companion", "PurpurBars"})
public final class RamBarTask
extends BossBarTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PurpurBars plugin;
    private long allocated;
    private long used;
    private long xmx;
    private long xms;
    private float percent;
    private int tick;
    @Nullable
    private static RamBarTask instance;

    public RamBarTask(@NotNull PurpurBars plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        super(plugin);
        this.plugin = plugin;
    }

    public final long getAllocated() {
        return this.allocated;
    }

    public final long getUsed() {
        return this.used;
    }

    public final long getXmx() {
        return this.xmx;
    }

    public final long getXms() {
        return this.xms;
    }

    public final float getPercent() {
        return this.percent;
    }

    public final int getTick() {
        return this.tick;
    }

    @Override
    @NotNull
    public BossBar createBossBar() {
        BossBar bossBar = BossBar.bossBar((Component)((Component)Component.text((String)"")), (float)0.0f, (BossBar.Color)Companion.instance(this.plugin).getBossBarColor(), (BossBar.Overlay)this.plugin.getMainConfigManager().getRambar().getProgressOverlay());
        Intrinsics.checkNotNullExpressionValue((Object)bossBar, (String)"bossBar(...)");
        return bossBar;
    }

    @Override
    public void updateBossBar(@NotNull BossBar bossbar, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)bossbar, (String)"bossbar");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        bossbar.progress(this.percent);
        bossbar.color(this.getBossBarColor());
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component((String)"allocated", (ComponentLike)((ComponentLike)this.format(this.allocated))), Placeholder.component((String)"used", (ComponentLike)((ComponentLike)this.format(this.used))), Placeholder.component((String)"xmx", (ComponentLike)((ComponentLike)this.format(this.xmx))), Placeholder.component((String)"xms", (ComponentLike)((ComponentLike)this.format(this.xms))), Placeholder.unparsed((String)"percent", (String)((int)(this.percent * (float)100) + "%"))};
        bossbar.name(MiniMessage.miniMessage().deserialize(this.plugin.getMainConfigManager().getRambar().getTitle(), tagResolverArray));
    }

    @Override
    public void run() {
        ++this.tick;
        if (this.tick < this.plugin.getMainConfigManager().getRambar().getTickInterval()) {
            return;
        }
        this.tick = 0;
        MemoryUsage heap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        this.allocated = heap.getCommitted();
        this.used = heap.getUsed();
        this.xmx = heap.getMax();
        this.xms = heap.getInit();
        this.percent = Math.max(Math.min((float)this.used / (float)this.xmx, 1.0f), 0.0f);
        super.run();
    }

    private final BossBar.Color getBossBarColor() {
        return this.percent < 0.5f ? this.plugin.getMainConfigManager().getRambar().getProgressColor().getGood() : (this.percent < 0.75f ? this.plugin.getMainConfigManager().getRambar().getProgressColor().getMedium() : this.plugin.getMainConfigManager().getRambar().getProgressColor().getLow());
    }

    @NotNull
    public final Component format(long v) {
        String string;
        String color;
        String string2 = this.percent < 0.6f ? this.plugin.getMainConfigManager().getRambar().getTextColor().getGood() : (color = this.percent < 0.85f ? this.plugin.getMainConfigManager().getRambar().getTextColor().getMedium() : this.plugin.getMainConfigManager().getRambar().getTextColor().getLow());
        if (v < 1024L) {
            string = v + "B";
        } else {
            int z = (63 - Long.numberOfLeadingZeros(v)) / 10;
            if (z > 2) {
                String string3 = "%.1f";
                Object[] objectArray = new Object[]{Float.valueOf((float)v / (float)(1L << z * 10))};
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                string = string4 + "BKMGTPE".charAt(z);
            } else {
                string = "" + v / (1L << z * 10) + "BKMGTPE".charAt(z);
            }
        }
        String value = string;
        Component component = MiniMessage.miniMessage().deserialize(color, (TagResolver)Placeholder.unparsed((String)"text", (String)value));
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
        return component;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnet/serlith/purpur/tasks/RamBarTask$Companion;", "", "<init>", "()V", "instance", "Lnet/serlith/purpur/tasks/RamBarTask;", "plugin", "Lnet/serlith/purpur/PurpurBars;", "PurpurBars"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RamBarTask instance(@NotNull PurpurBars plugin) {
            Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
            if (instance == null) {
                instance = new RamBarTask(plugin);
            }
            RamBarTask ramBarTask = instance;
            Intrinsics.checkNotNull((Object)((Object)ramBarTask));
            return ramBarTask;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

