/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.commands;

import java.util.List;
import net.serlith.purpur.PurpurBars;
import net.serlith.purpur.configs.RootConfig;
import net.serlith.purpur.tasks.CompassBarTask;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CompassCommand
extends Command
implements PluginIdentifiableCommand {
    private final PurpurBars plugin;
    private final List<String> empty = List.of();

    public CompassCommand(PurpurBars plugin) {
        super("compass");
        this.plugin = plugin;
        this.setPermission("purpurbars.monitor.compass");
        this.setUsage("/compass");
        this.setDescription("Displays a compass in hand using a bossbar");
        this.permissionMessage(plugin.getPrefix().append(RootConfig.MESSAGES._NO_PERMISSION));
        this.plugin.getServer().getCommandMap().register(this.plugin.getNamespace(), (Command)this);
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getPrefix().append(RootConfig.MESSAGES._NOT_PLAYER));
            return false;
        }
        Player player = (Player)sender;
        CompassBarTask.getInstance(this.plugin).togglePlayer(player);
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) throws IllegalArgumentException {
        return this.empty;
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }
}

