/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.commands;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.serlith.purpur.PurpurBars;
import net.serlith.purpur.configs.RootConfig;
import net.serlith.purpur.tasks.RamBarTask;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class RamCommand
extends Command
implements PluginIdentifiableCommand {
    private final PurpurBars plugin;
    private final List<String> empty = List.of();

    public RamCommand(PurpurBars plugin) {
        super("ram");
        this.plugin = plugin;
        this.setPermission("purpurbars.check.ram");
        this.setUsage("/ram");
        this.setDescription("Displays server RAM usage in the chat");
        this.permissionMessage(plugin.getPrefix().append(RootConfig.MESSAGES._NO_PERMISSION));
        this.plugin.getServer().getCommandMap().register(this.plugin.getNamespace(), (Command)this);
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        RamBarTask ramTask = RamBarTask.getInstance(this.plugin);
        RootConfig.FORMAT.RAM.OUTPUT.stream().map(i -> MiniMessage.miniMessage().deserialize(i, new TagResolver[]{Placeholder.component((String)"allocated", (ComponentLike)ramTask.format(ramTask.getAllocated())), Placeholder.component((String)"used", (ComponentLike)ramTask.format(ramTask.getUsed())), Placeholder.component((String)"xmx", (ComponentLike)ramTask.format(ramTask.getXmx())), Placeholder.component((String)"xms", (ComponentLike)ramTask.format(ramTask.getXms())), Placeholder.component((String)"bar", (ComponentLike)this.createProgressBar(ramTask.getUsed(), ramTask.getXmx())), Placeholder.parsed((String)"percent", (String)"%d%%".formatted((int)(ramTask.getPercent() * 100.0f)))})).forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
        return true;
    }

    private Component createProgressBar(long used, long max) {
        long usedLength = (long)RootConfig.FORMAT.RAM.USAGE_BAR.LENGTH * used / max;
        long unusedLength = (long)RootConfig.FORMAT.RAM.USAGE_BAR.LENGTH - usedLength;
        return ((TextComponent)((TextComponent)Component.text((String)RootConfig.FORMAT.RAM.USAGE_BAR.CHARS.START, (TextColor)RootConfig.FORMAT.RAM.USAGE_BAR.COLOR._BORDER).append((Component)Component.text((String)RootConfig.FORMAT.RAM.USAGE_BAR.CHARS.BAR.repeat((int)usedLength), (TextColor)RootConfig.FORMAT.RAM.USAGE_BAR.COLOR._USED))).append((Component)Component.text((String)RootConfig.FORMAT.RAM.USAGE_BAR.CHARS.BAR.repeat((int)unusedLength), (TextColor)RootConfig.FORMAT.RAM.USAGE_BAR.COLOR._UNUSED))).append((Component)Component.text((String)RootConfig.FORMAT.RAM.USAGE_BAR.CHARS.END, (TextColor)RootConfig.FORMAT.RAM.USAGE_BAR.COLOR._BORDER));
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) throws IllegalArgumentException {
        return this.empty;
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }
}

