/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.libs.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.serlith.purpur.libs.boostedyaml.YamlDocument;
import net.serlith.purpur.libs.boostedyaml.block.Block;
import net.serlith.purpur.libs.boostedyaml.block.Comments;
import net.serlith.purpur.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import net.serlith.purpur.libs.boostedyaml.route.Route;
import net.serlith.purpur.libs.boostedyaml.settings.dumper.DumperSettings;
import net.serlith.purpur.libs.boostedyaml.utils.format.NodeRole;
import net.serlith.purpur.libs.config.ConfigHandler;
import net.serlith.purpur.libs.config.StaticConfig;
import net.serlith.purpur.libs.config.utils.PathUtils;
import net.serlith.purpur.libs.config.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ConfigDocument
extends YamlDocument {
    private final StaticConfig config;
    private final ConfigHandler handler;
    private final boolean allowLoad;

    public ConfigDocument(StaticConfig config, InputStream defaults) throws IOException {
        super(config.getFile(), defaults, config.getHandler().getDocumentSettings());
        this.config = config;
        this.handler = config.getHandler();
        this.allowLoad = true;
    }

    @Override
    public String dump(@NotNull DumperSettings settings) {
        String dump = super.dump(settings);
        String content = this.handler.isFormatStructure() ? this.format(dump) : dump;
        String header = this.config.getHeader().stream().map(line -> "# " + line + "\n").collect(Collectors.joining());
        String footer = this.config.getFooter().stream().map(line -> "# " + line + "\n").collect(Collectors.joining());
        return header + (!header.isEmpty() ? "\n" : "") + content + "\n" + footer;
    }

    @Override
    public boolean reload() throws IOException {
        return this.allowLoad && super.reload();
    }

    public void wipeComments() {
        for (Route route : this.getRoutes(true)) {
            this.wipeComments(this.getBlock(route));
        }
        this.wipeComments(this);
    }

    public void wipeComments(Block<?> block) {
        if (block == null) {
            return;
        }
        for (NodeRole role : NodeRole.values()) {
            for (Comments.Position position : Comments.Position.values()) {
                Comments.remove(block, role, position);
            }
        }
    }

    protected void setComment(Block<?> block, StaticConfig.Comment comment) {
        if (block != null && comment != null) {
            this.setComment(block, Arrays.asList(comment.value()), comment.side());
        }
    }

    protected void setComment(Block<?> block, List<String> comment, boolean side) {
        if (block == null) {
            return;
        }
        Comments.Position position = side ? Comments.Position.INLINE : Comments.Position.BEFORE;
        NodeRole role = side ? NodeRole.VALUE : NodeRole.KEY;
        List<CommentLine> lines = comment.stream().map(line -> Comments.create(" " + line, position)).collect(Collectors.toList());
        Comments.set(block, role, position, lines);
    }

    public String format(String content) {
        ArrayList<String> formatted = new ArrayList<String>();
        String[] lines = content.split("\n");
        int previousIndentation = -1;
        boolean previousComment = false;
        for (int i = 0; i < lines.length; ++i) {
            boolean section;
            if (lines[i].isEmpty()) continue;
            int currentIndentation = StringUtils.getIndentation(lines[i]);
            boolean currentComment = lines[i].trim().startsWith("#");
            boolean comment = currentComment && !previousComment && previousIndentation >= currentIndentation;
            boolean bl = section = currentIndentation == 0 && previousIndentation > 0 && !previousComment;
            if (comment || section) {
                lines[i] = "\n" + lines[i];
            }
            previousIndentation = currentIndentation;
            previousComment = currentComment;
            formatted.add(lines[i]);
        }
        return String.join((CharSequence)"\n", formatted);
    }

    public String backup() throws IOException {
        Path path;
        Path path2 = path = this.getFile() != null ? this.getFile().toPath() : null;
        if (path == null) {
            throw new IllegalStateException("The document must be loaded to take a backup.");
        }
        return PathUtils.createBackup(path, this.handler.getBackupDateFormat());
    }
}

