/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.libs.config;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import lombok.Generated;
import net.serlith.purpur.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import net.serlith.purpur.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import net.serlith.purpur.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;
import net.serlith.purpur.libs.boostedyaml.settings.Settings;
import net.serlith.purpur.libs.boostedyaml.settings.dumper.DumperSettings;
import net.serlith.purpur.libs.boostedyaml.settings.general.GeneralSettings;
import net.serlith.purpur.libs.boostedyaml.settings.loader.LoaderSettings;
import net.serlith.purpur.libs.boostedyaml.utils.format.NodeRole;
import net.serlith.purpur.libs.config.StaticConfig;
import net.serlith.purpur.libs.config.exception.MissingProviderException;
import net.serlith.purpur.libs.config.message.Message;
import net.serlith.purpur.libs.config.provider.TypeProvider;
import net.serlith.purpur.libs.config.provider.impl.BooleanProvider;
import net.serlith.purpur.libs.config.provider.impl.MessageProvider;
import net.serlith.purpur.libs.config.provider.impl.NumberProvider;
import net.serlith.purpur.libs.config.provider.impl.SimpleProvider;
import net.serlith.purpur.libs.config.resolver.TypeResolver;
import net.serlith.purpur.libs.config.resolver.impl.CollectionResolver;
import net.serlith.purpur.libs.config.resolver.impl.EnumResolver;
import net.serlith.purpur.libs.config.resolver.impl.MapResolver;
import net.serlith.purpur.libs.config.resolver.impl.RegistryResolver;

public class ConfigHandler {
    private final List<TypeResolver> resolvers = new ArrayList<TypeResolver>();
    private final RegistryResolver registry = new RegistryResolver();
    private final List<StaticConfig> registered = new ArrayList<StaticConfig>();
    private final Logger logger;
    private boolean formatStructure = true;
    private boolean formatValues = true;
    private boolean removeUnrecognised = true;
    private boolean createBackupOnRemove = true;
    private String backupDateFormat = "yyyy-MM-dd-hh-mm-a";
    private Function<String, String> keyFormatter = key -> key.toLowerCase().replace("_", "-");

    public ConfigHandler(Logger logger) {
        this.logger = logger;
        this.register(this.registry);
        this.register(new EnumResolver());
        this.register(new CollectionResolver(this));
        this.register(new MapResolver(this));
        this.bind(String.class, new SimpleProvider<String>(String::valueOf));
        this.bind(UUID.class, new SimpleProvider<UUID>(UUID::fromString));
        this.bind(URI.class, new SimpleProvider<URI>(URI::create));
        this.bind(Pattern.class, new SimpleProvider<Pattern>(Pattern::compile));
        this.bind(Integer.TYPE, new NumberProvider<Integer>(Integer::parseInt));
        this.bind(Long.TYPE, new NumberProvider<Long>(Long::parseLong));
        this.bind(Byte.TYPE, new NumberProvider<Byte>(Byte::parseByte));
        this.bind(Float.TYPE, new NumberProvider<Float>(Float::parseFloat));
        this.bind(Double.TYPE, new NumberProvider<Double>(Double::parseDouble));
        this.bind(Short.TYPE, new NumberProvider<Short>(Short::parseShort));
        this.bind(Boolean.TYPE, new BooleanProvider());
        this.bind(Message.class, new MessageProvider());
    }

    public ConfigHandler() {
        this(Logger.getLogger("ConfigAPI"));
    }

    public void register(TypeResolver resolver) {
        this.resolvers.add(resolver);
    }

    public <T> void bind(Class<T> type, TypeProvider<T> provider) {
        this.registry.register(type, provider);
    }

    public <T> TypeProvider<T> provide(Class<T> type, Field field) {
        for (TypeResolver resolver : this.resolvers) {
            TypeProvider<T> provider = resolver.resolve(type, field);
            if (provider == null) continue;
            return provider;
        }
        throw new MissingProviderException(type);
    }

    public <T> TypeProvider<T> provide(Class<T> type) {
        return this.provide(type, null);
    }

    public TypeProvider<?> provide(Field field) {
        return this.provide(field.getType(), field);
    }

    protected Settings[] getDocumentSettings() {
        GeneralSettings general = GeneralSettings.builder().setUseDefaults(false).build();
        LoaderSettings loader = LoaderSettings.builder().setAllowDuplicateKeys(false).build();
        DumperSettings dumper = DumperSettings.builder().setFlowStyle(FlowStyle.BLOCK).setIndicatorIndentation(2).setScalarFormatter((tag, value, role, def) -> role.equals((Object)NodeRole.VALUE) && tag.equals(Tag.STR) ? ScalarStyle.DOUBLE_QUOTED : def).build();
        return new Settings[]{general, loader, dumper};
    }

    @Generated
    protected Logger getLogger() {
        return this.logger;
    }

    @Generated
    protected boolean isFormatStructure() {
        return this.formatStructure;
    }

    @Generated
    protected boolean isFormatValues() {
        return this.formatValues;
    }

    @Generated
    protected boolean isRemoveUnrecognised() {
        return this.removeUnrecognised;
    }

    @Generated
    protected boolean isCreateBackupOnRemove() {
        return this.createBackupOnRemove;
    }

    @Generated
    protected String getBackupDateFormat() {
        return this.backupDateFormat;
    }

    @Generated
    protected Function<String, String> getKeyFormatter() {
        return this.keyFormatter;
    }

    @Generated
    public void setFormatStructure(boolean formatStructure) {
        this.formatStructure = formatStructure;
    }

    @Generated
    public void setFormatValues(boolean formatValues) {
        this.formatValues = formatValues;
    }

    @Generated
    public void setRemoveUnrecognised(boolean removeUnrecognised) {
        this.removeUnrecognised = removeUnrecognised;
    }

    @Generated
    public void setCreateBackupOnRemove(boolean createBackupOnRemove) {
        this.createBackupOnRemove = createBackupOnRemove;
    }

    @Generated
    public void setBackupDateFormat(String backupDateFormat) {
        this.backupDateFormat = backupDateFormat;
    }

    @Generated
    public void setKeyFormatter(Function<String, String> keyFormatter) {
        this.keyFormatter = keyFormatter;
    }

    @Generated
    public List<StaticConfig> getRegistered() {
        return this.registered;
    }
}

