/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.libs.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.serlith.purpur.libs.boostedyaml.block.Block;
import net.serlith.purpur.libs.boostedyaml.block.implementation.Section;
import net.serlith.purpur.libs.config.ConfigDocument;
import net.serlith.purpur.libs.config.ConfigHandler;
import net.serlith.purpur.libs.config.exception.LoadFailedException;
import net.serlith.purpur.libs.config.exception.SaveFailedException;
import net.serlith.purpur.libs.config.provider.context.LoadContext;
import net.serlith.purpur.libs.config.provider.context.SaveContext;
import net.serlith.purpur.libs.config.utils.ClassUtils;
import net.serlith.purpur.libs.config.utils.Pair;

public abstract class StaticConfig {
    private final File file;
    private final ConfigHandler handler;
    private final ConfigDocument document;
    private final Map<String, Field> fields = new HashMap<String, Field>();
    private final Map<String, Boolean> routes = new HashMap<String, Boolean>();
    private final Map<String, List<String>> relocations = new HashMap<String, List<String>>();
    private final Map<String, Pair<List<String>, Boolean>> comments = new HashMap<String, Pair<List<String>, Boolean>>();
    private boolean success = true;

    public StaticConfig(File file, InputStream defaults, ConfigHandler handler) {
        this.file = file;
        this.handler = handler;
        try {
            this.document = new ConfigDocument(this, defaults);
        }
        catch (IOException exception) {
            throw new IllegalStateException("Failed to instantiate document for '" + file.getName() + "'.");
        }
        handler.getRegistered().add(this);
    }

    public StaticConfig(File file, ConfigHandler handler) {
        this(file, null, handler);
    }

    public List<String> getHeader() {
        Header header = this.getClass().getAnnotation(Header.class);
        if (header == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(header.value());
    }

    public List<String> getFooter() {
        Footer footer = this.getClass().getAnnotation(Footer.class);
        if (footer == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(footer.value());
    }

    public void load() {
        try {
            this.document.reload();
            this.relocate();
            if (this.fields.isEmpty()) {
                this.stepWrapper(this.getClass(), "", true);
            }
            for (Map.Entry<String, Field> entry : this.fields.entrySet()) {
                String route = entry.getKey();
                Field field = entry.getValue();
                if (Modifier.isFinal(field.getModifiers())) continue;
                try {
                    if (!this.document.contains(route)) continue;
                    field.set(null, this.handler.provide(field).load(new LoadContext(route, this.document.get(route))));
                }
                catch (Exception exception) {
                    throw new IOException("Failed to load key '" + route + "'.", exception);
                }
            }
            this.save();
            if (this.handler.isFormatValues()) {
                this.format();
            }
        }
        catch (Exception exception) {
            this.success = false;
            throw new LoadFailedException(this.file, (Throwable)exception);
        }
        this.success = true;
    }

    public void save() {
        try {
            if (!this.success) {
                throw new IllegalStateException("Cannot save until successful load, check above for errors.");
            }
            if (this.document.getRoot() == null) {
                throw new IllegalStateException("Document must be loaded before it can be saved.");
            }
            if (this.handler.isFormatStructure()) {
                this.document.wipeComments();
            }
            this.document.wipeComments(this.document);
            this.stepWrapper(this.getClass(), "", false);
            this.setComments();
            this.document.save();
        }
        catch (Exception exception) {
            throw new SaveFailedException(this.file, (Throwable)exception);
        }
    }

    private void stepWrapper(Class<?> parent, String path, boolean initialize) throws ReflectiveOperationException, RuntimeException {
        ArrayList<Field> values = new ArrayList<Field>();
        values.addAll(Arrays.asList(parent.getDeclaredFields()));
        values.addAll(Arrays.asList(parent.getDeclaredClasses()).reversed());
        if (values.stream().noneMatch(e -> e.isAnnotationPresent(Order.class))) {
            this.step(parent, path, initialize);
            return;
        }
        values.stream().sorted((a, b) -> {
            int priorityA = a.isAnnotationPresent(Order.class) ? a.getAnnotation(Order.class).value() : Integer.MAX_VALUE;
            int priorityB = b.isAnnotationPresent(Order.class) ? b.getAnnotation(Order.class).value() : Integer.MAX_VALUE;
            return Integer.compare(priorityA, priorityB);
        }).forEach(a -> {
            try {
                if (a instanceof Field) {
                    boolean initial;
                    Field field = (Field)a;
                    if (!Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(Ignore.class)) {
                        return;
                    }
                    if (ClassUtils.isCompanionField(field)) {
                        return;
                    }
                    field.setAccessible(true);
                    String route = path + this.getRoute(field.getAnnotation(Key.class), field.getName());
                    if (initialize) {
                        this.routes.put(route, true);
                        this.fields.put(route, field);
                        return;
                    }
                    boolean hidden = field.isAnnotationPresent(Hidden.class);
                    boolean present = this.document.contains(route);
                    boolean bl = initial = (!present || Modifier.isFinal(field.getModifiers())) && !hidden;
                    if (initial || !hidden || present) {
                        this.set(route, field, field.get(null));
                    }
                    this.document.setComment(this.document.getBlock(route), field.getAnnotation(Comment.class));
                } else if (a instanceof Class) {
                    Section section;
                    Class clazz = (Class)a;
                    if (!Modifier.isStatic(clazz.getModifiers()) || clazz.isAnnotationPresent(Ignore.class)) {
                        return;
                    }
                    if (ClassUtils.isCompanionClass(clazz)) {
                        return;
                    }
                    String route = path + this.getRoute(clazz.getAnnotation(Key.class), clazz.getSimpleName());
                    if (initialize) {
                        this.routes.put(route, false);
                        this.step(clazz, route + ".", true);
                        return;
                    }
                    if (Modifier.isFinal(clazz.getModifiers())) {
                        this.document.remove(route);
                    }
                    if ((section = this.document.getSection(route)) == null && !clazz.isAnnotationPresent(Hidden.class)) {
                        section = this.document.createSection(route);
                    }
                    if (section != null) {
                        this.document.setComment(section, clazz.getAnnotation(Comment.class));
                        this.step(clazz, route + ".", false);
                    }
                }
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void step(Class<?> parent, String path, boolean initialize) throws ReflectiveOperationException {
        for (Field field : parent.getDeclaredFields()) {
            boolean initial;
            if (!Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(Ignore.class) || ClassUtils.isCompanionField(field)) continue;
            field.setAccessible(true);
            String route = path + this.getRoute(field.getAnnotation(Key.class), field.getName());
            if (initialize) {
                this.routes.put(route, true);
                this.fields.put(route, field);
                continue;
            }
            boolean hidden = field.isAnnotationPresent(Hidden.class);
            boolean present = this.document.contains(route);
            boolean bl = initial = (!present || Modifier.isFinal(field.getModifiers())) && !hidden;
            if (initial || !hidden || present) {
                this.set(route, field, field.get(null));
            }
            this.document.setComment(this.document.getBlock(route), field.getAnnotation(Comment.class));
        }
        Class<?>[] classes = parent.getDeclaredClasses();
        for (int i = classes.length - 1; i >= 0; --i) {
            Section section;
            Class<?> clazz = classes[i];
            if (!Modifier.isStatic(clazz.getModifiers()) || clazz.isAnnotationPresent(Ignore.class) || ClassUtils.isCompanionClass(clazz)) continue;
            String route = path + this.getRoute(clazz.getAnnotation(Key.class), clazz.getSimpleName());
            if (initialize) {
                this.routes.put(route, false);
                this.step(clazz, route + ".", true);
                continue;
            }
            if (Modifier.isFinal(clazz.getModifiers())) {
                this.document.remove(route);
            }
            if ((section = this.document.getSection(route)) == null && !clazz.isAnnotationPresent(Hidden.class)) {
                section = this.document.createSection(route);
            }
            if (section == null) continue;
            this.document.setComment(section, clazz.getAnnotation(Comment.class));
            this.step(clazz, route + ".", false);
        }
    }

    public void format() throws IOException {
        try {
            boolean removed = false;
            for (String route : this.document.getRoutesAsStrings(true)) {
                if (!this.fields.containsKey(route) && !this.routes.containsKey(route)) {
                    if (this.routes.entrySet().stream().anyMatch(entry -> (Boolean)entry.getValue() != false && route.startsWith((String)entry.getKey()))) continue;
                    boolean remove = this.handler.isRemoveUnrecognised();
                    this.handler.getLogger().warning((remove ? "Removed" : "Found") + " unrecognised key '" + route + "' from '" + this.file.getName() + "'.");
                    if (!remove) continue;
                    this.document.remove(route);
                    removed = true;
                    continue;
                }
                if (this.document.isSection(route)) continue;
                Field field = this.fields.get(route);
                this.set(route, field, field.get(null));
            }
            if (removed) {
                this.handler.getLogger().warning("Keys were removed from '" + this.file.getName() + "', a backup was saved to '" + this.document.backup() + "'.");
            }
            this.document.save();
        }
        catch (Exception exception) {
            throw new IOException("Format failed for file '" + this.file.getName() + "'.", exception);
        }
    }

    protected void relocate(String target, String replacement) {
        this.relocations.computeIfAbsent(replacement, key -> new ArrayList()).add(target);
    }

    private void relocate() {
        this.relocations.forEach((replacement, targets) -> {
            for (String target : targets) {
                if (!this.document.contains(target)) continue;
                this.document.set((String)replacement, this.document.get(target));
                this.document.remove(target);
                this.handler.getLogger().warning("Value from '" + target + "' was relocated to '" + replacement + "'.");
            }
        });
    }

    protected void setComment(String route, boolean side, String ... comment) {
        this.comments.put(route, new Pair<List<String>, Boolean>(Arrays.asList(comment), side));
    }

    protected void setComment(String route, String ... comment) {
        this.setComment(route, false, comment);
    }

    private void setComments() {
        this.comments.forEach((route, comment) -> {
            Block<?> block = this.document.getBlock((String)route);
            if (block == null) {
                return;
            }
            List<String> comments = block.getComments();
            if (comments != null && !comments.isEmpty()) {
                return;
            }
            this.document.setComment(block, (List)comment.getLeft(), (Boolean)comment.getRight());
        });
    }

    private <T> void set(String key, Field field, T value) {
        SaveContext<T> context = new SaveContext<T>(key, value);
        Object object = this.handler.provide(field).save(context);
        this.document.set(context.getKey(), object);
    }

    private String getRoute(Key key, String name) {
        boolean valid = key != null && !key.value().trim().isEmpty();
        return valid ? key.value() : this.handler.getKeyFormatter().apply(name);
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public ConfigHandler getHandler() {
        return this.handler;
    }

    @Generated
    public ConfigDocument getDocument() {
        return this.document;
    }

    @Generated
    public Map<String, List<String>> getRelocations() {
        return this.relocations;
    }

    @Generated
    public Map<String, Pair<List<String>, Boolean>> getComments() {
        return this.comments;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Header {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Footer {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    protected static @interface Ignore {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    protected static @interface Key {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    protected static @interface Hidden {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    protected static @interface Comment {
        public String[] value();

        public boolean side() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface Order {
        public int value();
    }
}

