/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.libs.config.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;

public class Message {
    private static Function<String, String> defaultMapper;
    private final List<String> lines;
    private final boolean initial;

    private Message(Collection<String> lines, boolean initial) {
        this.lines = new ArrayList<String>(lines);
        this.initial = initial;
    }

    public static Message of(Collection<String> lines) {
        return new Message(lines, true);
    }

    public static Message of(String ... lines) {
        return new Message(Arrays.asList(lines), true);
    }

    private Message supply(Consumer<List<String>> consumer) {
        Message message = this.initial ? new Message(this.lines, false) : this;
        consumer.accept(message.lines);
        return message;
    }

    public Message map(Function<String, String> mapper) {
        return this.supply(lines -> lines.replaceAll(mapper::apply));
    }

    public Message filter(Predicate<String> filter) {
        return this.supply(lines -> lines.removeIf(filter));
    }

    public Message replace(String target, String replacement) {
        return this.map(line -> line.replaceAll(target, replacement));
    }

    public void send(Consumer<String> consumer) {
        Message message = defaultMapper != null ? this.map(defaultMapper) : this;
        message.lines.forEach(consumer);
    }

    @Generated
    public List<String> getLines() {
        return this.lines;
    }

    @Generated
    public boolean isInitial() {
        return this.initial;
    }

    @Generated
    public static void setDefaultMapper(Function<String, String> defaultMapper) {
        Message.defaultMapper = defaultMapper;
    }
}

