/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.libs.config.provider.impl;

import java.util.Arrays;
import java.util.List;
import net.serlith.purpur.libs.config.provider.TypeProvider;
import net.serlith.purpur.libs.config.provider.context.LoadContext;
import net.serlith.purpur.libs.config.provider.context.SaveContext;

public class BooleanProvider
implements TypeProvider<Boolean> {
    private static final List<String> TRUE_VALUES = Arrays.asList("true", "yes", "1");
    private static final List<String> FALSE_VALUES = Arrays.asList("false", "no", "0");

    @Override
    public Boolean load(LoadContext context) {
        String lowered = String.valueOf(context.getObject()).toLowerCase();
        for (String value : TRUE_VALUES) {
            if (!lowered.equals(value)) continue;
            return true;
        }
        for (String value : FALSE_VALUES) {
            if (!lowered.equals(value)) continue;
            return false;
        }
        throw new IllegalArgumentException("A boolean value must be provided.");
    }

    @Override
    public Object save(SaveContext<Boolean> context) {
        return context.getObject();
    }
}

