/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.libs.config.provider.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import lombok.Generated;
import net.serlith.purpur.libs.config.ConfigHandler;
import net.serlith.purpur.libs.config.provider.TypeProvider;
import net.serlith.purpur.libs.config.provider.context.LoadContext;
import net.serlith.purpur.libs.config.provider.context.SaveContext;
import net.serlith.purpur.libs.config.utils.ClassUtils;

public class CollectionProvider<E, T extends Collection<E>>
implements TypeProvider<T> {
    private final Supplier<T> supplier;
    private final Class<E> generic;
    private final ConfigHandler handler;

    public CollectionProvider(Field field, Supplier<T> supplier, Class<T> ignored, ConfigHandler handler) {
        this(supplier, (Class)(field != null ? ClassUtils.getGenerics(field)[0] : null), handler);
        if (field == null) {
            throw new IllegalStateException("Nested collections are not supported!");
        }
    }

    @Override
    public T load(LoadContext context) {
        TypeProvider<E> provider = this.handler.provide(this.generic);
        Collection collection = (Collection)this.supplier.get();
        if (!Collection.class.isAssignableFrom(context.getObject().getClass())) {
            collection.add(provider.load(context));
            return (T)collection;
        }
        int index = 0;
        for (Object element : (Collection)context.getObject()) {
            collection.add(provider.load(new LoadContext(String.valueOf(index++), element)));
        }
        return (T)collection;
    }

    @Override
    public Object save(SaveContext<T> context) {
        TypeProvider<E> provider = this.handler.provide(this.generic);
        ArrayList<Object> list = new ArrayList<Object>();
        int index = 0;
        for (Object element : (Collection)context.getObject()) {
            list.add(provider.save(new SaveContext(String.valueOf(index++), element)));
        }
        return list;
    }

    @Generated
    public CollectionProvider(Supplier<T> supplier, Class<E> generic, ConfigHandler handler) {
        this.supplier = supplier;
        this.generic = generic;
        this.handler = handler;
    }
}

