/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.libs.config.provider.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import net.serlith.purpur.libs.boostedyaml.block.implementation.Section;
import net.serlith.purpur.libs.config.ConfigHandler;
import net.serlith.purpur.libs.config.provider.TypeProvider;
import net.serlith.purpur.libs.config.provider.context.LoadContext;
import net.serlith.purpur.libs.config.provider.context.SaveContext;

public class MapProvider<E, T extends Map<String, E>>
implements TypeProvider<T> {
    private final Class<E> generic;
    private final ConfigHandler handler;

    @Override
    public T load(LoadContext context) {
        if (!(context.getObject() instanceof Section)) {
            throw new IllegalArgumentException("Mapped route must resolve to section.");
        }
        Section section = (Section)context.getObject();
        LinkedHashMap<String, E> entries = new LinkedHashMap<String, E>();
        TypeProvider<E> provider = this.handler.provide(this.generic);
        for (String key : section.getStringRouteMappedValues(false).keySet()) {
            entries.put(key, provider.load(new LoadContext(key, section.get(key))));
        }
        return (T)entries;
    }

    @Override
    public Object save(SaveContext<T> saveContext) {
        LinkedHashMap<String, Object> entries = new LinkedHashMap<String, Object>();
        TypeProvider<E> provider = this.handler.provide(this.generic);
        for (Map.Entry entry : ((Map)saveContext.getObject()).entrySet()) {
            SaveContext context = new SaveContext((String)entry.getKey(), entry.getValue());
            Object object = provider.save(context);
            entries.put(context.getKey(), object);
        }
        return entries;
    }

    @Generated
    public MapProvider(Class<E> generic, ConfigHandler handler) {
        this.generic = generic;
        this.handler = handler;
    }
}

