/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.libs.config.utils;

import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import lombok.Generated;

public final class ClassUtils {
    public static Type[] getGenerics(Field field) {
        ParameterizedType type = (ParameterizedType)field.getGenericType();
        return type.getActualTypeArguments();
    }

    public static <T> Class<T> wrap(Class<T> type) {
        return MethodType.methodType(type).wrap().returnType();
    }

    public static boolean isCompanionClass(Class<?> clazz) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            return false;
        }
        if (!Modifier.isStatic(clazz.getModifiers())) {
            return false;
        }
        return clazz.getSimpleName().equals("Companion");
    }

    public static boolean isCompanionField(Field field) {
        if (!ClassUtils.isCompanionClass(field.getType())) {
            return false;
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (!Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        return field.getName().equals("Companion");
    }

    @Generated
    private ClassUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

