/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.libs.config.utils;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;

public final class PathUtils {
    public static String createBackup(Path path, String format) throws IOException {
        String date = new SimpleDateFormat(format).format(new Date());
        String name = PathUtils.getBaseName(path) + "-" + date + PathUtils.getExtension(path);
        return Files.copy(path, path.resolveSibling(name), new CopyOption[0]).toFile().getName();
    }

    public static String getBaseName(Path path) {
        String name = path.getFileName().toString();
        return name.contains(".") ? name.substring(0, name.lastIndexOf(".")) : name;
    }

    public static String getExtension(Path path) {
        String name = path.getFileName().toString();
        return name.contains(".") ? name.substring(name.lastIndexOf(".")) : "";
    }

    @Generated
    private PathUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

