/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.tasks;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import lombok.Generated;
import net.kyori.adventure.bossbar.BossBar;
import net.serlith.purpur.PurpurBars;
import net.serlith.purpur.configs.RootConfig;
import net.serlith.purpur.tasks.CompassBarTask;
import net.serlith.purpur.tasks.RamBarTask;
import net.serlith.purpur.tasks.TpsBarTask;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BossBarTask
extends BukkitRunnable {
    private final PurpurBars plugin;
    private final Map<UUID, BossBar> bossBars = new HashMap<UUID, BossBar>();
    private boolean started = false;
    private final BiConsumer<UUID, BossBar> taskRun = (uuid, bossBar) -> {
        @Nullable Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            this.updateBossBar((BossBar)bossBar, player);
        }
    };
    private static final Comparator<BossBarTask> taskCompare = Comparator.comparingInt(a -> RootConfig.JOIN_EVENT.ORDER.indexOf((Object)a.getType()));

    abstract BossBar createBossBar();

    abstract void updateBossBar(BossBar var1, Player var2);

    abstract Type getType();

    public void run() {
        this.bossBars.forEach(this.taskRun);
    }

    public void cancel() {
        super.cancel();
        this.bossBars.forEach((uuid, bossBar) -> {});
    }

    public Set<UUID> getAllPlayerUUIDs() {
        return this.bossBars.keySet();
    }

    public abstract Set<UUID> loadAllPlayerUUIDs();

    public void initializeAllPlayerUUIDs() {
        this.loadAllPlayerUUIDs().forEach(u -> this.bossBars.put((UUID)u, this.createBossBar()));
    }

    public boolean removePlayer(@NotNull Player player) {
        @Nullable BossBar bossBar = this.bossBars.remove(player.getUniqueId());
        if (bossBar != null) {
            player.hideBossBar(bossBar);
            return true;
        }
        return false;
    }

    public void addPlayer(@NotNull Player player) {
        this.removePlayer(player);
        BossBar bossBar = this.createBossBar();
        this.bossBars.put(player.getUniqueId(), bossBar);
        this.updateBossBar(bossBar, player);
        player.showBossBar(bossBar);
    }

    public void refreshPlayer(@NotNull Player player) {
        @Nullable BossBar bossBar = this.bossBars.get(player.getUniqueId());
        if (bossBar != null) {
            player.showBossBar(bossBar);
        }
    }

    public void togglePlayer(@NotNull Player player) {
        if (this.removePlayer(player)) {
            return;
        }
        this.addPlayer(player);
    }

    public void start() {
        this.stop();
        this.runTaskTimerAsynchronously((Plugin)this.plugin, 1L, 1L);
        this.started = true;
    }

    public void stop() {
        if (this.started) {
            this.cancel();
        }
    }

    public void dumpAndStop() {
        this.stop();
    }

    public static void startAll() {
        Stream.of(new BossBarTask[]{TpsBarTask.getInstance(PurpurBars.getInstance()), RamBarTask.getInstance(PurpurBars.getInstance()), CompassBarTask.getInstance(PurpurBars.getInstance())}).forEach(BossBarTask::start);
    }

    public static void dumpAndStopAll() {
        Stream.of(new BossBarTask[]{TpsBarTask.getInstance(PurpurBars.getInstance()), RamBarTask.getInstance(PurpurBars.getInstance()), CompassBarTask.getInstance(PurpurBars.getInstance())}).forEach(BossBarTask::dumpAndStop);
    }

    public static void loadAll() {
        Stream.of(new BossBarTask[]{TpsBarTask.getInstance(PurpurBars.getInstance()), RamBarTask.getInstance(PurpurBars.getInstance()), CompassBarTask.getInstance(PurpurBars.getInstance())}).forEach(BossBarTask::initializeAllPlayerUUIDs);
    }

    public static void refreshAll(Player player) {
        Stream.of(new BossBarTask[]{TpsBarTask.getInstance(PurpurBars.getInstance()), RamBarTask.getInstance(PurpurBars.getInstance()), CompassBarTask.getInstance(PurpurBars.getInstance())}).sorted(taskCompare).forEach(a -> a.refreshPlayer(player));
    }

    @Generated
    public BossBarTask(PurpurBars plugin) {
        this.plugin = plugin;
    }

    public static enum Type {
        TPS_BAR,
        RAM_BAR,
        COMPASS_BAR;

    }
}

