/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.tasks;

import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.serlith.purpur.PurpurBars;
import net.serlith.purpur.configs.RootConfig;
import net.serlith.purpur.data.DataStorage;
import net.serlith.purpur.tasks.BossBarTask;
import org.bukkit.entity.Player;

public class CompassBarTask
extends BossBarTask {
    private static CompassBarTask INSTANCE;
    private int tick = 0;

    public static CompassBarTask getInstance(PurpurBars plugin) {
        if (INSTANCE == null) {
            INSTANCE = new CompassBarTask(plugin);
        }
        return INSTANCE;
    }

    private CompassBarTask(PurpurBars plugin) {
        super(plugin);
    }

    @Override
    BossBar createBossBar() {
        return BossBar.bossBar((Component)Component.empty(), (float)RootConfig.FORMAT.COMPASS_BAR.PROGRESS_PERCENT, (BossBar.Color)RootConfig.FORMAT.COMPASS_BAR.PROGRESS_COLOR, (BossBar.Overlay)RootConfig.FORMAT.COMPASS_BAR.PROGRESS_OVERLAY);
    }

    @Override
    void updateBossBar(BossBar bossBar, Player player) {
        float yaw = player.getLocation().getYaw();
        int length = RootConfig.FORMAT.COMPASS_BAR.TITLE.length();
        int pos = (int)(this.normalize(yaw) * ((float)length / 720.0f) + (float)length / 2.0f);
        bossBar.name((Component)Component.text((String)RootConfig.FORMAT.COMPASS_BAR.TITLE.substring(pos - 25, pos + 25)));
    }

    @Override
    BossBarTask.Type getType() {
        return BossBarTask.Type.COMPASS_BAR;
    }

    @Override
    public void run() {
        if (++this.tick % RootConfig.FORMAT.COMPASS_BAR.TICK_INTERVAL != 0) {
            return;
        }
        super.run();
    }

    @Override
    public void dumpAndStop() {
        DataStorage.COMPASS_BAR = this.getAllPlayerUUIDs();
        super.dumpAndStop();
    }

    @Override
    public Set<UUID> loadAllPlayerUUIDs() {
        return DataStorage.COMPASS_BAR;
    }

    private float normalize(float yaw) {
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw > 180.0f) {
            yaw -= 360.0f;
        }
        return yaw;
    }

    @Generated
    public int getTick() {
        return this.tick;
    }
}

