/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.tasks;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.serlith.purpur.PurpurBars;
import net.serlith.purpur.configs.RootConfig;
import net.serlith.purpur.data.DataStorage;
import net.serlith.purpur.tasks.BossBarTask;
import org.bukkit.entity.Player;

public class RamBarTask
extends BossBarTask {
    private static RamBarTask INSTANCE;
    private final PurpurBars plugin;
    private long allocated = 0L;
    private long used = 0L;
    private long xmx = 0L;
    private long xms = 0L;
    private float percent = 0.0f;
    private int tick = 0;
    private final char[] sizes = new char[]{'B', 'K', 'M', 'G', 'T', 'P', 'E'};

    public static RamBarTask getInstance(PurpurBars plugin) {
        if (INSTANCE == null) {
            INSTANCE = new RamBarTask(plugin);
        }
        return INSTANCE;
    }

    public RamBarTask(PurpurBars plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @Override
    public BossBar createBossBar() {
        return BossBar.bossBar((Component)Component.empty(), (float)0.0f, (BossBar.Color)RamBarTask.getInstance(this.plugin).getBossBarColor(), (BossBar.Overlay)RootConfig.FORMAT.RAM_BAR.PROGRESS_OVERLAY);
    }

    @Override
    public void updateBossBar(BossBar bossBar, Player player) {
        bossBar.progress(this.getPercent());
        bossBar.color(this.getBossBarColor());
        bossBar.name(MiniMessage.miniMessage().deserialize(RootConfig.FORMAT.RAM_BAR.TITLE, new TagResolver[]{Placeholder.component((String)"allocated", (ComponentLike)this.format(this.allocated)), Placeholder.component((String)"used", (ComponentLike)this.format(this.used)), Placeholder.component((String)"xmx", (ComponentLike)this.format(this.xmx)), Placeholder.component((String)"xms", (ComponentLike)this.format(this.xms)), Placeholder.parsed((String)"percent", (String)"%d%%".formatted((int)(this.percent * 100.0f)))}));
    }

    @Override
    public BossBarTask.Type getType() {
        return BossBarTask.Type.RAM_BAR;
    }

    @Override
    public void run() {
        if (++this.tick % RootConfig.FORMAT.RAM_BAR.TICK_INTERVAL != 0) {
            return;
        }
        MemoryUsage heap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        this.allocated = heap.getCommitted();
        this.used = heap.getUsed();
        this.xmx = heap.getMax();
        this.xms = heap.getInit();
        this.percent = Math.max(Math.min((float)this.used / (float)this.xmx, 1.0f), 0.0f);
        super.run();
    }

    @Override
    public void dumpAndStop() {
        DataStorage.RAM_BAR = this.getAllPlayerUUIDs();
        super.dumpAndStop();
    }

    @Override
    public Set<UUID> loadAllPlayerUUIDs() {
        return DataStorage.RAM_BAR;
    }

    private BossBar.Color getBossBarColor() {
        BossBar.Color color = this.percent < 0.5f ? RootConfig.FORMAT.RAM_BAR.PROGRESS_COLOR.GOOD : (this.percent < 0.75f ? RootConfig.FORMAT.RAM_BAR.PROGRESS_COLOR.MEDIUM : RootConfig.FORMAT.RAM_BAR.PROGRESS_COLOR.LOW);
        return color;
    }

    public Component format(long v) {
        int z;
        String colored = this.percent < 0.6f ? RootConfig.FORMAT.RAM_BAR.TEXT_COLOR.GOOD : (this.percent < 0.85f ? RootConfig.FORMAT.RAM_BAR.TEXT_COLOR.MEDIUM : RootConfig.FORMAT.RAM_BAR.TEXT_COLOR.LOW);
        String value = v < 1024L ? "%dB".formatted(v) : ((z = (63 - Long.numberOfLeadingZeros(v)) / 10) > 2 ? "%.1f%c".formatted(Float.valueOf((float)v / (float)(1L << z * 10)), Character.valueOf(this.sizes[z])) : "%d%c".formatted(v / (1L << z * 10), Character.valueOf(this.sizes[z])));
        return MiniMessage.miniMessage().deserialize(colored, (TagResolver)Placeholder.unparsed((String)"text", (String)value));
    }

    @Generated
    public long getAllocated() {
        return this.allocated;
    }

    @Generated
    public long getUsed() {
        return this.used;
    }

    @Generated
    public long getXmx() {
        return this.xmx;
    }

    @Generated
    public long getXms() {
        return this.xms;
    }

    @Generated
    public float getPercent() {
        return this.percent;
    }

    @Generated
    public int getTick() {
        return this.tick;
    }
}

