/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.tasks;

import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.serlith.purpur.PurpurBars;
import net.serlith.purpur.configs.RootConfig;
import net.serlith.purpur.data.DataStorage;
import net.serlith.purpur.listeners.ServerListener;
import net.serlith.purpur.tasks.BossBarTask;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TpsBarTask
extends BossBarTask {
    private static TpsBarTask INSTANCE;
    private final PurpurBars plugin;
    private double tps = 20.0;
    private double mspt = 0.0;
    private int tick = 0;

    public static TpsBarTask getInstance(PurpurBars plugin) {
        if (INSTANCE == null) {
            INSTANCE = new TpsBarTask(plugin);
        }
        return INSTANCE;
    }

    public TpsBarTask(PurpurBars plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @Override
    public BossBar createBossBar() {
        return BossBar.bossBar((Component)Component.empty(), (float)0.0f, (BossBar.Color)TpsBarTask.getInstance(this.plugin).getBossBarColor(), (BossBar.Overlay)RootConfig.FORMAT.TPS_BAR.PROGRESS_OVERLAY);
    }

    @Override
    public void updateBossBar(BossBar bossBar, Player player) {
        bossBar.progress(this.getPercent());
        bossBar.color(this.getBossBarColor());
        bossBar.name(MiniMessage.miniMessage().deserialize(RootConfig.FORMAT.TPS_BAR.TITLE, new TagResolver[]{Placeholder.component((String)"tps", (ComponentLike)this.getTpsColor()), Placeholder.component((String)"mspt", (ComponentLike)this.getMsptColor()), Placeholder.component((String)"ping", (ComponentLike)this.getPingColor(player.getPing()))}));
    }

    @Override
    public BossBarTask.Type getType() {
        return BossBarTask.Type.TPS_BAR;
    }

    @Override
    public void run() {
        if (++this.tick % RootConfig.FORMAT.TPS_BAR.TICK_INTERVAL != 0) {
            return;
        }
        this.tps = Math.max(Math.min(ServerListener.TPS_5_SEC.getAverage(), 20.0), 0.0);
        this.mspt = Bukkit.getAverageTickTime();
        super.run();
    }

    @Override
    public void dumpAndStop() {
        DataStorage.TPS_BAR = this.getAllPlayerUUIDs();
        super.dumpAndStop();
    }

    @Override
    public Set<UUID> loadAllPlayerUUIDs() {
        return DataStorage.TPS_BAR;
    }

    public float getPercent() {
        if (RootConfig.FORMAT.TPS_BAR.PROGRESS_FILL_MODE == ProgressFillMode.MSPT) {
            return Math.max(Math.min((float)this.mspt / 50.0f, 1.0f), 0.0f);
        }
        return Math.max(Math.min((float)this.tps / 20.0f, 1.0f), 0.0f);
    }

    private BossBar.Color getBossBarColor() {
        BossBar.Color color = this.isGood(RootConfig.FORMAT.TPS_BAR.PROGRESS_FILL_MODE, 0) ? RootConfig.FORMAT.TPS_BAR.PROGRESS_COLOR.GOOD : (this.isMedium(RootConfig.FORMAT.TPS_BAR.PROGRESS_FILL_MODE, 0) ? RootConfig.FORMAT.TPS_BAR.PROGRESS_COLOR.MEDIUM : RootConfig.FORMAT.TPS_BAR.PROGRESS_COLOR.LOW);
        return color;
    }

    private boolean isGood(ProgressFillMode mode, int ping) {
        return switch (mode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> {
                if (this.mspt < 40.0) {
                    yield true;
                }
                yield false;
            }
            case 0 -> {
                if (this.tps >= 19.0) {
                    yield true;
                }
                yield false;
            }
            case 2 -> ping < 100;
        };
    }

    private boolean isMedium(ProgressFillMode mode, int ping) {
        return switch (mode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> {
                if (this.mspt < 50.0) {
                    yield true;
                }
                yield false;
            }
            case 0 -> {
                if (this.tps >= 15.0) {
                    yield true;
                }
                yield false;
            }
            case 2 -> ping < 200;
        };
    }

    private Component getTpsColor() {
        return MiniMessage.miniMessage().deserialize(this.getColor(ProgressFillMode.TPS, 0), (TagResolver)Placeholder.parsed((String)"text", (String)"%.2f".formatted(this.tps)));
    }

    private Component getMsptColor() {
        return MiniMessage.miniMessage().deserialize(this.getColor(ProgressFillMode.MSPT, 0), (TagResolver)Placeholder.parsed((String)"text", (String)"%.2f".formatted(this.mspt)));
    }

    private Component getPingColor(int ping) {
        return MiniMessage.miniMessage().deserialize(this.getColor(ProgressFillMode.PING, ping), (TagResolver)Placeholder.parsed((String)"text", (String)"%d".formatted(ping)));
    }

    private String getColor(ProgressFillMode mode, int ping) {
        String colored = this.isGood(mode, ping) ? RootConfig.FORMAT.TPS_BAR.TEXT_COLOR.GOOD : (this.isMedium(mode, ping) ? RootConfig.FORMAT.TPS_BAR.TEXT_COLOR.MEDIUM : RootConfig.FORMAT.TPS_BAR.TEXT_COLOR.LOW);
        return colored;
    }

    @Generated
    public double getTps() {
        return this.tps;
    }

    @Generated
    public double getMspt() {
        return this.mspt;
    }

    @Generated
    public int getTick() {
        return this.tick;
    }

    public static enum ProgressFillMode {
        TPS,
        MSPT,
        PING;

    }
}

