/*
 * Decompiled with CFR 0.152.
 */
package net.serlith.purpur.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.serlith.purpur.PurpurBars;
import net.serlith.purpur.tasks.RamBarTask;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J/\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0010\u0010\u000f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J7\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\t2\u0010\u0010\u000f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/serlith/purpur/commands/RamCommand;", "Lorg/bukkit/command/Command;", "Lorg/bukkit/command/PluginIdentifiableCommand;", "plugin", "Lnet/serlith/purpur/PurpurBars;", "<init>", "(Lnet/serlith/purpur/PurpurBars;)V", "empty", "", "", "execute", "", "sender", "Lorg/bukkit/command/CommandSender;", "commandLabel", "args", "", "(Lorg/bukkit/command/CommandSender;Ljava/lang/String;[Ljava/lang/String;)Z", "createProgressBar", "Lnet/kyori/adventure/text/ComponentLike;", "used", "", "max", "tabComplete", "alias", "(Lorg/bukkit/command/CommandSender;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "getPlugin", "Lorg/bukkit/plugin/Plugin;", "PurpurBars"})
@SourceDebugExtension(value={"SMAP\nRamCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RamCommand.kt\nnet/serlith/purpur/commands/RamCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1557#2:72\n1628#2,3:73\n1863#2,2:76\n*S KotlinDebug\n*F\n+ 1 RamCommand.kt\nnet/serlith/purpur/commands/RamCommand\n*L\n33#1:72\n33#1:73,3\n42#1:76,2\n*E\n"})
public final class RamCommand
extends Command
implements PluginIdentifiableCommand {
    @NotNull
    private final PurpurBars plugin;
    @NotNull
    private final List<String> empty;

    public RamCommand(@NotNull PurpurBars plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        super("ram");
        this.plugin = plugin;
        this.empty = CollectionsKt.emptyList();
        this.setPermission("purpurbars.check.ram");
        this.setUsage("/ram");
        this.description = "Displays server RAM usage in the chat";
        this.permissionMessage(MiniMessage.miniMessage().deserialize((Object)(this.plugin.getPrefix() + this.plugin.getMainConfigManager().getMessages().getNoPermission())));
        this.plugin.getServer().getCommandMap().register(this.plugin.getNamespace(), (Command)this);
    }

    /*
     * WARNING - void declaration
     */
    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @Nullable String[] args) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)commandLabel, (String)"commandLabel");
        RamBarTask rambar = RamBarTask.Companion.instance(this.plugin);
        Iterable $this$map$iv = this.plugin.getMainConfigManager().getRam().getOutput();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component((String)"allocated", (ComponentLike)((ComponentLike)rambar.format(rambar.getAllocated()))), Placeholder.component((String)"used", (ComponentLike)((ComponentLike)rambar.format(rambar.getUsed()))), Placeholder.component((String)"xmx", (ComponentLike)((ComponentLike)rambar.format(rambar.getXmx()))), Placeholder.component((String)"xms", (ComponentLike)((ComponentLike)rambar.format(rambar.getXms()))), Placeholder.component((String)"bar", (ComponentLike)this.createProgressBar(rambar.getUsed(), rambar.getXmx())), Placeholder.unparsed((String)"percent", (String)((int)(rambar.getPercent() * (float)100) + "%"))};
            collection.add(MiniMessage.miniMessage().deserialize((String)it, tagResolverArray));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            sender.sendMessage(it);
        }
        return true;
    }

    private final ComponentLike createProgressBar(long used, long max) {
        long usedLength = (long)this.plugin.getMainConfigManager().getRam().getLength() * used / max;
        long unusedLength = (long)this.plugin.getMainConfigManager().getRam().getLength() - usedLength;
        String charBar = this.plugin.getMainConfigManager().getRam().getChar().getBar();
        String charStart = this.plugin.getMainConfigManager().getRam().getChar().getStart();
        String charEnd = this.plugin.getMainConfigManager().getRam().getChar().getEnd();
        String usedColor = this.plugin.getMainConfigManager().getRam().getColor().getUsed();
        String unusedColor = this.plugin.getMainConfigManager().getRam().getColor().getUnused();
        String usedBar = "<color:" + usedColor + ">" + StringsKt.repeat((CharSequence)charBar, (int)((int)usedLength)) + "</color:" + usedColor + ">";
        String unusedBar = "<color:" + unusedColor + ">" + StringsKt.repeat((CharSequence)charBar, (int)((int)unusedLength)) + "</color:" + unusedColor + ">";
        String borderColor = this.plugin.getMainConfigManager().getRam().getColor().getBorder();
        Component component = MiniMessage.miniMessage().deserialize((Object)("<color:" + borderColor + ">" + charStart + "</color:" + borderColor + "> " + usedBar + unusedBar + " <color:" + borderColor + ">" + charEnd + "</color:" + borderColor + ">"));
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
        return (ComponentLike)component;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @Nullable String[] args) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        return this.empty;
    }

    @NotNull
    public Plugin getPlugin() {
        return (Plugin)this.plugin;
    }
}

