/*
 * Decompiled with CFR 0.152.
 */
package net.ali.magitech;

import java.util.function.Supplier;
import net.ali.magitech.client.IsVisibleClientPacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class IsVisiblePacket {
    public final boolean isVisible;
    public final String targetEntityUUID;

    public IsVisiblePacket(boolean isVisible, LivingEntity targetEntity) {
        this.isVisible = isVisible;
        this.targetEntityUUID = targetEntity.m_20148_().toString();
    }

    public IsVisiblePacket(FriendlyByteBuf buf) {
        this.isVisible = buf.readBoolean();
        this.targetEntityUUID = buf.m_130136_(36);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isVisible);
        buf.m_130070_(this.targetEntityUUID);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                IsVisibleClientPacketHandler.handle(this);
            }
        });
        context.setPacketHandled(true);
    }
}

