/*
 * Decompiled with CFR 0.152.
 */
package net.ali.magitech;

public class LootExchangerValues {
    static final ExchangeableItem[] itemValues = new ExchangeableItem[]{new ExchangeableItem("minecraft:rotten_flesh", 0.0625), new ExchangeableItem("minecraft:bone", 0.0625), new ExchangeableItem("minecraft:string", 0.0625), new ExchangeableItem("minecraft:gunpowder", 0.0625), new ExchangeableItem("minecraft:spider_eye", 0.0625), new ExchangeableItem("minecraft:ender_pearl", 0.0625), new ExchangeableItem("minecraft:prismarine_shard", 0.0625), new ExchangeableItem("minecraft:slime_ball", 0.0625), new ExchangeableItem("minecraft:phantom_membrane", 0.0625), new ExchangeableItem("minecraft:nautilus_shell", 0.125), new ExchangeableItem("minecraft:name_tag", 0.125), new ExchangeableItem("minecraft:experience_bottle", 0.25), new ExchangeableItem("minecraft:blaze_rod", 0.25), new ExchangeableItem("minecraft:ghast_tear", 0.25), new ExchangeableItem("minecraft:iron_horse_armor", 1.0), new ExchangeableItem("minecraft:golden_horse_armor", 1.0), new ExchangeableItem("minecraft:diamond_horse_armor", 1.0), new ExchangeableItem("magitech:saturated_rotten_flesh", 2.0), new ExchangeableItem("minecraft:player_head", 2.0), new ExchangeableItem("minecraft:zombie_head", 2.0), new ExchangeableItem("minecraft:creeper_head", 2.0), new ExchangeableItem("minecraft:heart_of_the_sea", 2.0), new ExchangeableItem("minecraft:sculk_catalyst", 2.0), new ExchangeableItem("magitech:pure_sunlight_energy", 4.0), new ExchangeableItem("minecraft:diamond", 4.0), new ExchangeableItem("minecraft:totem_of_undying", 4.0), new ExchangeableItem("minecraft:dragon_breath", 4.0), new ExchangeableItem("minecraft:echo_shard", 4.0), new ExchangeableItem("minecraft:enchanted_golden_apple", 6.0), new ExchangeableItem("minecraft:elytra", 6.0), new ExchangeableItem("minecraft:dragon_head", 6.0), new ExchangeableItem("minecraft:ancient_debris", 6.0), new ExchangeableItem("magitech:sunlight_magirune", 8.0), new ExchangeableItem("minecraft:nether_star", 16.0)};

    public static boolean IsItemValid(String item) {
        for (int i = 0; i < itemValues.length; ++i) {
            if (!itemValues[i].GetItemId().equals(item)) continue;
            return true;
        }
        return false;
    }

    public static int EmeraldsToGive(String item) {
        for (int i = 0; i < itemValues.length; ++i) {
            if (!itemValues[i].GetItemId().equals(item)) continue;
            return itemValues[i].EmeraldsToGive();
        }
        return -1;
    }

    public static int AmountFromValue(String item, double val) {
        for (int i = 0; i < itemValues.length; ++i) {
            if (!itemValues[i].GetItemId().equals(item)) continue;
            return itemValues[i].AmountFromValue(val);
        }
        return -1;
    }

    public static double GetValue(String item) {
        for (int i = 0; i < itemValues.length; ++i) {
            if (!itemValues[i].GetItemId().equals(item)) continue;
            return itemValues[i].GetValue();
        }
        return -1.0;
    }

    public static String GetToolTipOfItem(String item) {
        String v = String.valueOf((double)Math.round(LootExchangerValues.GetValue(item) * 100000.0) / 100000.0);
        v = v.indexOf(".") < 0 ? v : v.replaceAll("0*$", "").replaceAll("\\.$", "");
        return "\u00a7a\u00a7lValue: " + (String)(LootExchangerValues.IsItemValid(item) ? "\u00a7e" + v + " Emeralds" : "\u00a7cNONE");
    }

    public static class ExchangeableItem {
        String itemId;
        double value;

        public ExchangeableItem(String itemId, double value) {
            this.itemId = itemId;
            this.value = value;
        }

        public String GetItemId() {
            return this.itemId;
        }

        public double GetValue() {
            return this.value;
        }

        public int EmeraldsToGive() {
            return (int)Math.floor(this.value);
        }

        public int AmountFromValue(double val) {
            return (int)Math.floor(val / this.value);
        }
    }
}

