/*
 * Decompiled with CFR 0.152.
 */
package net.ali.magitech;

import java.util.HashMap;
import net.ali.magitech.MagitechMod;
import net.ali.magitech.procedures.MagitabletDataRegistryProcedure;
import net.minecraft.resources.ResourceLocation;

public class MagitabletDataTracker {
    private static HashMap<String, MagitabletDataEntry> dataEntries = new HashMap();

    public static void registerMagitabletDataEntry(String id, MagitabletDataEntry entry) {
        String errorMessage = "Couldn't register Magitablet Data Entry with the following ID: \"" + id + "\"; ";
        if (MagitabletDataTracker.doesEntryIdExist(id)) {
            MagitechMod.LOGGER.error(errorMessage + "Data Entry with the same ID already exists!");
            return;
        }
        if (entry == null) {
            MagitechMod.LOGGER.error(errorMessage + "Data Entry is null!");
            return;
        }
        if (entry.getTitle() == null || entry.getBody() == null || entry.getImageResource() == null || entry.getImageText() == null) {
            MagitechMod.LOGGER.error(errorMessage + "Data Entry has null values!");
            return;
        }
        dataEntries.put(id, entry);
    }

    public static MagitabletDataEntry getEntryByID(String id) {
        return dataEntries.get(id);
    }

    public static boolean doesEntryIdExist(String id) {
        return dataEntries.containsKey(id);
    }

    public static String getEntryTitle(String id) {
        return MagitabletDataTracker.getEntryByID(id).getTitle();
    }

    public static String getEntryBody(String id) {
        return MagitabletDataTracker.getEntryByID(id).getBody();
    }

    public static ResourceLocation getEntryImageResource(String id) {
        return MagitabletDataTracker.getEntryByID(id).getImageResource();
    }

    public static String getEntryImageText(String id) {
        return MagitabletDataTracker.getEntryByID(id).getImageText();
    }

    public static String[] getAllIDs() {
        return dataEntries.keySet().toArray(new String[0]);
    }

    static {
        MagitabletDataRegistryProcedure.execute();
    }

    public static class MagitabletDataEntry {
        private String title;
        private String body;
        private ResourceLocation imagePath;
        private String imageText;

        public MagitabletDataEntry(String title, String body, String imagePath, String imageText) {
            this.title = title;
            this.body = body;
            this.imagePath = new ResourceLocation(imagePath);
            this.imageText = imageText;
        }

        public String getTitle() {
            return this.title;
        }

        public String getBody() {
            return this.body;
        }

        public ResourceLocation getImageResource() {
            return this.imagePath;
        }

        public String getImageText() {
            return this.imageText;
        }
    }
}

