/*
 * Decompiled with CFR 0.152.
 */
package net.ali.magitech;

import java.util.function.Supplier;
import net.ali.magitech.client.MagitoastClientPacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class MagitoastSyncPacket {
    public final String instanceName;
    public final String title;
    public final String message;
    public final String type;
    public final int time;
    public final Boolean isRemoved;
    public final Boolean isCreated;

    public MagitoastSyncPacket(String instanceName, String title, String message, String type, int time, Boolean isRemoved, Boolean isCreated) {
        this.instanceName = instanceName;
        this.title = title;
        this.message = message;
        this.type = type;
        this.time = time;
        this.isRemoved = isRemoved;
        this.isCreated = isCreated;
    }

    public MagitoastSyncPacket(FriendlyByteBuf buf) {
        this.instanceName = buf.m_130136_(Short.MAX_VALUE);
        this.title = buf.m_130136_(Short.MAX_VALUE);
        this.message = buf.m_130136_(Short.MAX_VALUE);
        this.type = buf.m_130136_(Short.MAX_VALUE);
        this.time = buf.readInt();
        this.isRemoved = buf.readBoolean();
        this.isCreated = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.instanceName);
        buf.m_130070_(this.title);
        buf.m_130070_(this.message);
        buf.m_130070_(this.type);
        buf.writeInt(this.time);
        buf.writeBoolean(this.isRemoved.booleanValue());
        buf.writeBoolean(this.isCreated.booleanValue());
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                MagitoastClientPacketHandler.handle(this);
            }
        });
        context.setPacketHandled(true);
    }
}

