/*
 * Decompiled with CFR 0.152.
 */
package net.ali.magitech;

import java.util.function.Supplier;
import net.ali.magitech.client.VelocityClientPacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class VelocityPacket {
    public final double vx;
    public final double vy;
    public final double vz;
    public final boolean isPush;

    public VelocityPacket(double vx, double vy, double vz, boolean isPush) {
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
        this.isPush = isPush;
    }

    public VelocityPacket(FriendlyByteBuf buf) {
        this.vx = buf.readDouble();
        this.vy = buf.readDouble();
        this.vz = buf.readDouble();
        this.isPush = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.vx);
        buf.writeDouble(this.vy);
        buf.writeDouble(this.vz);
        buf.writeBoolean(this.isPush);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                VelocityClientPacketHandler.handle(this);
            }
        });
        context.setPacketHandled(true);
    }
}

