/*
 * Decompiled with CFR 0.152.
 */
package net.ali.magitech.network;

import java.util.function.Supplier;
import net.ali.magitech.MagitechMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MagitechModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MagitechMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        MagitechMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.manatricity = message.data.manatricity;
                    variables.manatricityThreshold = message.data.manatricityThreshold;
                    variables.mtBuffer = message.data.mtBuffer;
                    variables.activatedMagipower1 = message.data.activatedMagipower1;
                    variables.activatedMagipower2 = message.data.activatedMagipower2;
                    variables.magipowerCooldown = message.data.magipowerCooldown;
                    variables.plantMagipowerPhotosynthesis = message.data.plantMagipowerPhotosynthesis;
                    variables.sunlightZombiePotionBrewCooldown = message.data.sunlightZombiePotionBrewCooldown;
                    variables.isBountyHalved = message.data.isBountyHalved;
                    variables.earthKeeperCounter = message.data.earthKeeperCounter;
                    variables.magitabletData = message.data.magitabletData;
                    variables.openedDataEntry = message.data.openedDataEntry;
                    variables.gotFreebieMagitablet = message.data.gotFreebieMagitablet;
                    variables.lightTimeSprinting = message.data.lightTimeSprinting;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double manatricity = 0.0;
        public double manatricityThreshold = 0.0;
        public double mtBuffer = 0.0;
        public boolean activatedMagipower1 = false;
        public boolean activatedMagipower2 = false;
        public double magipowerCooldown = 0.0;
        public double plantMagipowerPhotosynthesis = 0.0;
        public double sunlightZombiePotionBrewCooldown = 0.0;
        public boolean isBountyHalved = false;
        public double earthKeeperCounter = 0.0;
        public String magitabletData = "";
        public String openedDataEntry = "";
        public boolean gotFreebieMagitablet = false;
        public double lightTimeSprinting = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MagitechMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("manatricity", this.manatricity);
            nbt.m_128347_("manatricityThreshold", this.manatricityThreshold);
            nbt.m_128347_("mtBuffer", this.mtBuffer);
            nbt.m_128379_("activatedMagipower1", this.activatedMagipower1);
            nbt.m_128379_("activatedMagipower2", this.activatedMagipower2);
            nbt.m_128347_("magipowerCooldown", this.magipowerCooldown);
            nbt.m_128347_("plantMagipowerPhotosynthesis", this.plantMagipowerPhotosynthesis);
            nbt.m_128347_("sunlightZombiePotionBrewCooldown", this.sunlightZombiePotionBrewCooldown);
            nbt.m_128379_("isBountyHalved", this.isBountyHalved);
            nbt.m_128347_("earthKeeperCounter", this.earthKeeperCounter);
            nbt.m_128359_("magitabletData", this.magitabletData);
            nbt.m_128359_("openedDataEntry", this.openedDataEntry);
            nbt.m_128379_("gotFreebieMagitablet", this.gotFreebieMagitablet);
            nbt.m_128347_("lightTimeSprinting", this.lightTimeSprinting);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.manatricity = nbt.m_128459_("manatricity");
            this.manatricityThreshold = nbt.m_128459_("manatricityThreshold");
            this.mtBuffer = nbt.m_128459_("mtBuffer");
            this.activatedMagipower1 = nbt.m_128471_("activatedMagipower1");
            this.activatedMagipower2 = nbt.m_128471_("activatedMagipower2");
            this.magipowerCooldown = nbt.m_128459_("magipowerCooldown");
            this.plantMagipowerPhotosynthesis = nbt.m_128459_("plantMagipowerPhotosynthesis");
            this.sunlightZombiePotionBrewCooldown = nbt.m_128459_("sunlightZombiePotionBrewCooldown");
            this.isBountyHalved = nbt.m_128471_("isBountyHalved");
            this.earthKeeperCounter = nbt.m_128459_("earthKeeperCounter");
            this.magitabletData = nbt.m_128461_("magitabletData");
            this.openedDataEntry = nbt.m_128461_("openedDataEntry");
            this.gotFreebieMagitablet = nbt.m_128471_("gotFreebieMagitablet");
            this.lightTimeSprinting = nbt.m_128459_("lightTimeSprinting");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("magitech", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "magitech_mapvars";
        public double magipowerAbility0Cooldown = 0.5;
        public double magipowerAbility1Cooldown = 1.0;
        public double magipowerAbility2Cooldown = 3.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.magipowerAbility0Cooldown = nbt.m_128459_("magipowerAbility0Cooldown");
            this.magipowerAbility1Cooldown = nbt.m_128459_("magipowerAbility1Cooldown");
            this.magipowerAbility2Cooldown = nbt.m_128459_("magipowerAbility2Cooldown");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("magipowerAbility0Cooldown", this.magipowerAbility0Cooldown);
            nbt.m_128347_("magipowerAbility1Cooldown", this.magipowerAbility1Cooldown);
            nbt.m_128347_("magipowerAbility2Cooldown", this.magipowerAbility2Cooldown);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                MagitechMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "magitech_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                MagitechMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.manatricityThreshold = original.manatricityThreshold;
            clone.sunlightZombiePotionBrewCooldown = original.sunlightZombiePotionBrewCooldown;
            clone.isBountyHalved = original.isBountyHalved;
            clone.earthKeeperCounter = original.earthKeeperCounter;
            clone.magitabletData = original.magitabletData;
            clone.openedDataEntry = original.openedDataEntry;
            clone.gotFreebieMagitablet = original.gotFreebieMagitablet;
            if (!event.isWasDeath()) {
                clone.manatricity = original.manatricity;
                clone.mtBuffer = original.mtBuffer;
                clone.activatedMagipower1 = original.activatedMagipower1;
                clone.activatedMagipower2 = original.activatedMagipower2;
                clone.magipowerCooldown = original.magipowerCooldown;
                clone.plantMagipowerPhotosynthesis = original.plantMagipowerPhotosynthesis;
                clone.lightTimeSprinting = original.lightTimeSprinting;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    MagitechMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    MagitechMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                MagitechMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

