/*
 * Decompiled with CFR 0.152.
 */
package net.ali.magitech.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.ali.magitech.entity.MagicastEntity;
import net.ali.magitech.procedures.ClampProcedure;
import net.ali.magitech.procedures.GeneratePlaneProcedure;
import net.ali.magitech.procedures.LerpProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class MagicastRenderProcedure {
    private static boolean texture = false;
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static PoseStack poseStack = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.f_82478_;
    private static float partialTick = 0.0f;
    private static int ticks = 0;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(double x, double y, double z, float u, float v, int color) {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            return;
        }
        if (texture) {
            bufferBuilder.m_5483_(x, y, z).m_7421_(u, v).m_193479_(color).m_5752_();
        } else {
            bufferBuilder.m_5483_(x, y, z).m_193479_(color).m_5752_();
        }
    }

    private static boolean begin(VertexFormat.Mode mode, boolean texture, boolean update) {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            if (update) {
                MagicastRenderProcedure.clear();
            }
            if (vertexBuffer == null) {
                MagicastRenderProcedure.texture = texture;
                bufferBuilder = Tesselator.m_85913_().m_85915_();
                if (texture) {
                    bufferBuilder.m_166779_(mode, DefaultVertexFormat.f_85819_);
                } else {
                    bufferBuilder.m_166779_(mode, DefaultVertexFormat.f_85815_);
                }
                return true;
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        vertexBuffer.m_85921_();
        vertexBuffer.m_231221_(bufferBuilder.m_231175_());
        VertexBuffer.m_85931_();
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        MagicastRenderProcedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            MagicastRenderProcedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (!worldCoordinate) {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        } else {
            Vec3 pos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            i = (float)(x - pos.m_7096_());
            j = (float)(y - pos.m_7098_());
            k = (float)(z - pos.m_7094_());
        }
        poseStack.m_85836_();
        poseStack.m_252880_(i, j, k);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(xScale, yScale, zScale);
        poseStack.m_85837_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.m_85921_();
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        vertexBuffer.m_253207_(matrix4f, projectionMatrix, vertexBuffer.m_166892_().hasUV(0) ? GameRenderer.m_172820_() : GameRenderer.m_172811_());
        VertexBuffer.m_85931_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        poseStack = event.getPoseStack();
        projectionMatrix = event.getProjectionMatrix();
        partialTick = event.getPartialTick();
        ticks = event.getRenderTick();
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            RenderSystem.depthMask((boolean)false);
            MagicastRenderProcedure.renderShapes((Event)event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            RenderSystem.depthMask((boolean)true);
            MagicastRenderProcedure.renderShapes((Event)event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
        }
        currentStage = 0;
    }

    private static void renderShapes(Event event) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
        if (level != null && entity != null) {
            Vec3 pos = entity.m_20318_(partialTick);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            MagicastRenderProcedure.execute(event, (LevelAccessor)level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), partialTick, ticks);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, double partialTick, double ticks) {
        MagicastRenderProcedure.execute(null, world, x, y, z, partialTick, ticks);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, double partialTick, double ticks) {
        VertexBuffer plane = null;
        double scale = 0.0;
        double pX = 0.0;
        double pY = 0.0;
        double pZ = 0.0;
        plane = GeneratePlaneProcedure.execute();
        if (MagicastRenderProcedure.target(2)) {
            Vec3 _center = new Vec3(x, y, z);
            List<Entity> _entfound = world.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(64.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).toList();
            for (Entity entityiterator : _entfound) {
                MagicastEntity _datEntL9;
                int n;
                int n2;
                MagicastEntity _datEntI;
                if (!(entityiterator instanceof MagicastEntity)) continue;
                if (entityiterator instanceof MagicastEntity) {
                    _datEntI = (MagicastEntity)entityiterator;
                    n2 = (Integer)_datEntI.m_20088_().m_135370_(MagicastEntity.DATA_ticksSinceSpawn);
                } else {
                    n2 = 0;
                }
                double d = ClampProcedure.execute(1.0, 0.0, (double)n2 / 10.0);
                if (entityiterator instanceof MagicastEntity) {
                    _datEntI = (MagicastEntity)entityiterator;
                    n = (Integer)_datEntI.m_20088_().m_135370_(MagicastEntity.DATA_ticksSinceSpawn);
                } else {
                    n = 0;
                }
                scale = LerpProcedure.execute(d, ClampProcedure.execute(1.0, 0.0, (double)(n + 1) / 10.0), partialTick);
                pX = LerpProcedure.execute(entityiterator.getPersistentData().m_128459_("magicastPosX"), entityiterator.m_20185_(), partialTick);
                pY = LerpProcedure.execute(entityiterator.getPersistentData().m_128459_("magicastPosY"), entityiterator.m_20186_(), partialTick);
                pZ = LerpProcedure.execute(entityiterator.getPersistentData().m_128459_("magicastPosZ"), entityiterator.m_20189_(), partialTick);
                if (!(entityiterator instanceof MagicastEntity) || !((Boolean)(_datEntL9 = (MagicastEntity)entityiterator).m_20088_().m_135370_(MagicastEntity.DATA_isGreaterMagicast)).booleanValue()) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("magitech:textures/magicast_0.png"));
                    MagicastRenderProcedure.renderShape(plane, pX, pY + 0.01, pZ, (float)((ticks + partialTick) * 5.0), 0.0f, 0.0f, (float)(scale * 3.0), (float)(scale * 3.0), (float)(scale * 3.0), (int)entityiterator.getPersistentData().m_128459_("magicastColor"));
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("magitech:textures/magicast_1.png"));
                    MagicastRenderProcedure.renderShape(plane, pX, pY + 0.15 + 0.01, pZ, (float)((ticks + partialTick) * -5.0), 0.0f, 0.0f, (float)(scale * 3.0), (float)(scale * 3.0), (float)(scale * 3.0), (int)entityiterator.getPersistentData().m_128459_("magicastColor"));
                    continue;
                }
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("magitech:textures/greater_magicast_0.png"));
                MagicastRenderProcedure.renderShape(plane, pX, pY + 0.01, pZ, (float)((ticks + partialTick) * 5.0), 0.0f, 0.0f, (float)(scale * 5.0), (float)(scale * 5.0), (float)(scale * 5.0), (int)entityiterator.getPersistentData().m_128459_("magicastColor"));
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("magitech:textures/greater_magicast_1.png"));
                MagicastRenderProcedure.renderShape(plane, pX, pY + 1.0 + 0.01, pZ, (float)((ticks + partialTick) * -5.0), 0.0f, 0.0f, (float)(scale * 3.0), (float)(scale * 3.0), (float)(scale * 3.0), (int)entityiterator.getPersistentData().m_128459_("magicastColor"));
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("magitech:textures/greater_magicast_2.png"));
                MagicastRenderProcedure.renderShape(plane, pX, pY + 2.5 + 0.01, pZ, (float)((ticks + partialTick) * 5.0), 0.0f, 0.0f, (float)(scale * 1.5), (float)(scale * 1.5), (float)(scale * 1.5), (int)entityiterator.getPersistentData().m_128459_("magicastColor"));
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("magitech:textures/greater_magicast_1.png"));
                MagicastRenderProcedure.renderShape(plane, pX, pY + 4.0 + 0.01, pZ, (float)((ticks + partialTick) * -5.0), 0.0f, 0.0f, (float)(scale * 3.0), (float)(scale * 3.0), (float)(scale * 3.0), (int)entityiterator.getPersistentData().m_128459_("magicastColor"));
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("magitech:textures/greater_magicast_0.png"));
                MagicastRenderProcedure.renderShape(plane, pX, pY + 5.0 + 0.01, pZ, (float)((ticks + partialTick) * 5.0), 0.0f, 0.0f, (float)(scale * 5.0), (float)(scale * 5.0), (float)(scale * 5.0), (int)entityiterator.getPersistentData().m_128459_("magicastColor"));
            }
            MagicastRenderProcedure.release();
        }
    }
}

