/*
 * Decompiled with CFR 0.152.
 */
package net.ali.magitech.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.ali.magitech.entity.MagipowerDropEntity;
import net.ali.magitech.procedures.LerpProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class MagipowerDropRenderProcedure {
    private static boolean texture = false;
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static PoseStack poseStack = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.f_82478_;
    private static float partialTick = 0.0f;
    private static int ticks = 0;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(double x, double y, double z, float u, float v, int color) {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            return;
        }
        if (texture) {
            bufferBuilder.m_5483_(x, y, z).m_7421_(u, v).m_193479_(color).m_5752_();
        } else {
            bufferBuilder.m_5483_(x, y, z).m_193479_(color).m_5752_();
        }
    }

    private static boolean begin(VertexFormat.Mode mode, boolean texture, boolean update) {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            if (update) {
                MagipowerDropRenderProcedure.clear();
            }
            if (vertexBuffer == null) {
                MagipowerDropRenderProcedure.texture = texture;
                bufferBuilder = Tesselator.m_85913_().m_85915_();
                if (texture) {
                    bufferBuilder.m_166779_(mode, DefaultVertexFormat.f_85819_);
                } else {
                    bufferBuilder.m_166779_(mode, DefaultVertexFormat.f_85815_);
                }
                return true;
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        vertexBuffer.m_85921_();
        vertexBuffer.m_231221_(bufferBuilder.m_231175_());
        VertexBuffer.m_85931_();
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        MagipowerDropRenderProcedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            MagipowerDropRenderProcedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (!worldCoordinate) {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        } else {
            Vec3 pos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            i = (float)(x - pos.m_7096_());
            j = (float)(y - pos.m_7098_());
            k = (float)(z - pos.m_7094_());
        }
        poseStack.m_85836_();
        poseStack.m_252880_(i, j, k);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(xScale, yScale, zScale);
        poseStack.m_85837_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.m_85921_();
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        vertexBuffer.m_253207_(matrix4f, projectionMatrix, vertexBuffer.m_166892_().hasUV(0) ? GameRenderer.m_172820_() : GameRenderer.m_172811_());
        VertexBuffer.m_85931_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        poseStack = event.getPoseStack();
        projectionMatrix = event.getProjectionMatrix();
        partialTick = event.getPartialTick();
        ticks = event.getRenderTick();
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            RenderSystem.depthMask((boolean)false);
            MagipowerDropRenderProcedure.renderShapes((Event)event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            RenderSystem.depthMask((boolean)true);
            MagipowerDropRenderProcedure.renderShapes((Event)event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
        }
        currentStage = 0;
    }

    private static void renderShapes(Event event) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
        if (level != null && entity != null) {
            Vec3 pos = entity.m_20318_(partialTick);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            MagipowerDropRenderProcedure.execute(event, (LevelAccessor)level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), partialTick);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, double partialTick) {
        MagipowerDropRenderProcedure.execute(null, world, x, y, z, partialTick);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, double partialTick) {
        double pX = 0.0;
        double pY = 0.0;
        double pZ = 0.0;
        if (MagipowerDropRenderProcedure.begin(VertexFormat.Mode.QUADS, true, false)) {
            MagipowerDropRenderProcedure.add(0.5, 0.5, 0.0, 0.0f, 0.0f, -1);
            MagipowerDropRenderProcedure.add(0.5, -0.5, 0.0, 0.0f, 1.0f, -1);
            MagipowerDropRenderProcedure.add(-0.5, -0.5, 0.0, 1.0f, 1.0f, -1);
            MagipowerDropRenderProcedure.add(-0.5, 0.5, 0.0, 1.0f, 0.0f, -1);
            MagipowerDropRenderProcedure.add(-0.5, 0.5, 0.0, 1.0f, 0.0f, -1);
            MagipowerDropRenderProcedure.add(-0.5, -0.5, 0.0, 1.0f, 1.0f, -1);
            MagipowerDropRenderProcedure.add(0.5, -0.5, 0.0, 0.0f, 1.0f, -1);
            MagipowerDropRenderProcedure.add(0.5, 0.5, 0.0, 0.0f, 0.0f, -1);
            MagipowerDropRenderProcedure.end();
        }
        if (MagipowerDropRenderProcedure.target(2)) {
            Vec3 _center = new Vec3(x, y, z);
            List<Entity> _entfound = world.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(64.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).toList();
            for (Entity entityiterator : _entfound) {
                if (!(entityiterator instanceof MagipowerDropEntity)) continue;
                pX = LerpProcedure.execute(entityiterator.getPersistentData().m_128459_("magipowerPosX"), entityiterator.m_20185_(), partialTick);
                pY = LerpProcedure.execute(entityiterator.getPersistentData().m_128459_("magipowerPosY"), entityiterator.m_20186_(), partialTick);
                pZ = LerpProcedure.execute(entityiterator.getPersistentData().m_128459_("magipowerPosZ"), entityiterator.m_20189_(), partialTick);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("magitech:textures/magipower_drop_orb_" + new DecimalFormat("##").format(Math.floor(entityiterator.getPersistentData().m_128459_("animationFrame") % 11.0)) + ".png"));
                MagipowerDropRenderProcedure.renderShape(MagipowerDropRenderProcedure.shape(), pX, pY + (double)entityiterator.m_20206_() * 0.5, pZ, Minecraft.m_91087_().f_91063_.m_109153_().m_90590_(), Minecraft.m_91087_().f_91063_.m_109153_().m_90589_(), 0.0f, 0.25f, 0.25f, 0.25f, -1);
            }
            MagipowerDropRenderProcedure.release();
        }
    }
}

