/*
 * Decompiled with CFR 0.152.
 */
package net.ali.magitech.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.ali.magitech.entity.ElectromagnetismShotHandlerEntity;
import net.ali.magitech.procedures.LerpProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderMagneticFieldProcedure {
    private static RenderLevelStageEvent provider = null;
    private static Map<EntityType, Entity> data = new HashMap<EntityType, Entity>();
    private static float textWidth = 1.0f;
    private static float textHeight = 1.0f;
    private static int textColor = -1;
    private static int backColor = 0;

    public static void setBackColor(int color) {
        backColor = color;
    }

    public static void setTextColor(int color) {
        textColor = color;
    }

    public static void setScale(float width, float height) {
        textWidth = width;
        textHeight = height;
    }

    public static void renderBlock(BlockState blockState, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        Vec3 pos = provider.getCamera().m_90583_();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, (BlockPos)blockPos);
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderMagneticFieldProcedure.renderBlockModel(blockState, blockPos, poseStack, packedLight);
        RenderMagneticFieldProcedure.renderBlockEntity(blockState, blockPos, poseStack, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderBlockEntity(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        Block block = blockState.m_60734_();
        if (block instanceof EntityBlock) {
            BlockEntityRenderer blockEntityRenderer;
            EntityBlock entityBlock = (EntityBlock)block;
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            BlockEntity blockEntity = entityBlock.m_142194_(blockPos, blockState);
            if (blockEntity != null && (blockEntityRenderer = minecraft.m_167982_().m_112265_(blockEntity)) != null) {
                MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
                blockEntity.m_142339_((Level)level);
                blockEntityRenderer.m_6922_(blockEntity, 0.0f, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.f_118083_);
            }
        }
    }

    private static void renderBlockModel(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        if (blockState.m_60799_() == RenderShape.MODEL) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
            BlockRenderDispatcher dispatcher = minecraft.m_91289_();
            ModelBlockRenderer renderer = dispatcher.m_110937_();
            BakedModel bakedModel = dispatcher.m_110910_(blockState);
            ModelData modelData = bakedModel.getModelData((BlockAndTintGetter)level, blockPos, blockState, ModelData.builder().build());
            PoseStack.Pose pose = poseStack.m_85850_();
            int color = minecraft.m_91298_().m_92582_(blockState, (Level)level, blockPos);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            for (RenderType renderType : bakedModel.getRenderTypes(blockState, RandomSource.m_216335_((long)42L), modelData)) {
                renderer.renderModel(pose, bufferSource.m_6299_(Sheets.m_110792_()), blockState, bakedModel, red, green, blue, packedLight, OverlayTexture.f_118083_, modelData, renderType);
            }
        }
    }

    public static void renderEntity(EntityType type, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        Entity entity;
        if (type == null) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (data.containsKey(type)) {
            entity = data.get(type);
            if (entity.m_9236_() != level) {
                entity = type.m_20615_((Level)level);
                data.put(type, entity);
            }
        } else {
            entity = type.m_20615_((Level)level);
            data.put(type, entity);
        }
        RenderMagneticFieldProcedure.renderEntity(entity, 0.0f, x, y, z, yaw, pitch, roll, scale, glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z)));
    }

    public static void renderEntity(Entity entity, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        float partialTick = provider.getPartialTick();
        int packedLight = glowing ? 0xF000F0 : Minecraft.m_91087_().m_91290_().m_114394_(entity, partialTick);
        RenderMagneticFieldProcedure.renderEntity(entity, partialTick, x, y, z, yaw, pitch, roll, scale, packedLight);
    }

    private static void renderEntity(Entity entity, float partialTick, double x, double y, double z, float yaw, float pitch, float roll, float scale, int packedLight) {
        if (entity == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        EntityRenderer renderer = minecraft.m_91290_().m_114382_(entity);
        Vec3 pos = provider.getCamera().m_90583_();
        float offset = entity.m_20206_() / 2.0f * scale;
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y + (double)offset - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_252880_(0.0f, -offset, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.m_7392_(entity, entity.m_5675_(partialTick), partialTick, poseStack, (MultiBufferSource)bufferSource, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderItem(ItemStack itemStack, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean flipping, boolean glowing) {
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        ItemRenderer renderer = minecraft.m_91291_();
        Vec3 pos = provider.getCamera().m_90583_();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.m_269491_(null, itemStack, ItemDisplayContext.FIXED, flipping, poseStack, (MultiBufferSource)bufferSource, (Level)minecraft.f_91073_, packedLight, OverlayTexture.f_118083_, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderLine(double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 pos = provider.getCamera().m_90583_();
        Vector3f normal = new Vec3(x2 - x1, y2 - y1, z2 - z1).m_82541_().m_252839_();
        Matrix4f matrix4f = provider.getPoseStack().m_85850_().m_252922_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110504_());
        vertexConsumer.m_252986_(matrix4f, (float)(x1 - pos.m_7096_()), (float)(y1 - pos.m_7098_()), (float)(z1 - pos.m_7094_())).m_193479_(color).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)(x2 - pos.m_7096_()), (float)(y2 - pos.m_7098_()), (float)(z2 - pos.m_7094_())).m_193479_(color).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
    }

    public static void renderTexts(String texts, double x, double y, double z, float yaw, float pitch, float roll, boolean glowing) {
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        Font font = minecraft.f_91062_;
        Vec3 pos = provider.getCamera().m_90583_();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(textWidth, -textHeight, 1.0f);
        float f = (float)(font.m_92895_(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.m_252880_(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (backColor != 0) {
            font.m_271703_(texts, 0.0f, 0.0f, 0, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, backColor, packedLight);
        }
        font.m_271703_(texts, 0.0f, 0.0f, textColor, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void renderModels(RenderLevelStageEvent event) {
        provider = event;
        if (provider.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            Entity entity = provider.getCamera().m_90592_();
            Vec3 pos = entity.m_20318_(provider.getPartialTick());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderMagneticFieldProcedure.execute((Event)provider, (LevelAccessor)level, provider.getPartialTick(), provider.getRenderTick());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public static void execute(LevelAccessor world, double partialTick, double ticks) {
        RenderMagneticFieldProcedure.execute(null, world, partialTick, ticks);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double partialTick, double ticks) {
        double ex = 0.0;
        double ey = 0.0;
        double ez = 0.0;
        double fticks = 0.0;
        double rotationAngle = 0.0;
        fticks = ticks + partialTick;
        if (world instanceof ClientLevel) {
            for (Entity entityiterator : ((ClientLevel)world).m_104735_()) {
                if (!(entityiterator instanceof ElectromagnetismShotHandlerEntity)) continue;
                ex = LerpProcedure.execute(entityiterator.getPersistentData().m_128459_("oldX"), entityiterator.m_20185_(), partialTick);
                ey = LerpProcedure.execute(entityiterator.getPersistentData().m_128459_("oldY"), entityiterator.m_20186_(), partialTick);
                ez = LerpProcedure.execute(entityiterator.getPersistentData().m_128459_("oldZ"), entityiterator.m_20189_(), partialTick);
                entityiterator.getPersistentData().m_128347_("rot", fticks * 0.0015625 % (Math.PI * 2));
                rotationAngle = entityiterator.getPersistentData().m_128459_("rot");
                Vec3 dipole = new Vec3(1.0, 0.0, 0.0);
                double radius = 1.0;
                int rings = 6;
                int pointsPerRing = 12;
                List<Vec3> seeds = RenderMagneticFieldProcedure.generate3DSeedPoints(radius, rings, pointsPerRing);
                for (int i = 0; i < seeds.size(); ++i) {
                    seeds.set(i, RenderMagneticFieldProcedure.rotateAroundYAxis(seeds.get(i), rotationAngle));
                }
                for (Vec3 seed : seeds) {
                    RenderMagneticFieldProcedure.traceAndRenderFieldLine(seed, dipole, 0.2, 150, ex, ey, ez);
                }
            }
        }
    }

    public static void traceAndRenderFieldLine(Vec3 seed, Vec3 dipole, double step, int maxSteps, double x, double y, double z) {
        List<Vec3> forward = RenderMagneticFieldProcedure.traceFieldLine(seed, dipole, step, maxSteps);
        List<Vec3> backward = RenderMagneticFieldProcedure.traceFieldLine(seed, dipole.m_82548_(), step, maxSteps);
        Collections.reverse(backward);
        backward.addAll(forward.subList(1, forward.size()));
        for (int i = 0; i < backward.size() - 1; ++i) {
            Vec3 from = backward.get(i);
            Vec3 to = backward.get(i + 1);
            RenderMagneticFieldProcedure.renderLine(x + from.m_7096_(), y + from.m_7098_(), z + from.m_7094_(), x + to.m_7096_(), y + to.m_7098_(), z + to.m_7094_(), 1084817384);
        }
    }

    public static Vec3 rotateAroundYAxis(Vec3 point, double angle) {
        double x = point.m_7096_() * Math.cos(angle) + point.m_7094_() * Math.sin(angle);
        double z = -point.m_7096_() * Math.sin(angle) + point.m_7094_() * Math.cos(angle);
        return new Vec3(x, point.m_7098_(), z);
    }

    public static List<Vec3> generate3DSeedPoints(double radius, int rings, int pointsPerRing) {
        ArrayList<Vec3> seeds = new ArrayList<Vec3>();
        for (int i = 0; i <= rings; ++i) {
            double theta = Math.PI * (double)i / (double)rings;
            for (int j = 0; j < pointsPerRing; ++j) {
                double phi = Math.PI * 2 * (double)j / (double)pointsPerRing;
                double x = radius * Math.sin(theta) * Math.cos(phi);
                double y = radius * Math.cos(theta);
                double z = radius * Math.sin(theta) * Math.sin(phi);
                seeds.add(new Vec3(x, y, z));
            }
        }
        return seeds;
    }

    public static Vec3 magneticFieldAt(Vec3 pos, Vec3 dipoleMoment) {
        double r = pos.m_82553_();
        if (r < 1.0E-6) {
            return Vec3.f_82478_;
        }
        double r2 = r * r;
        double r3 = r2 * r;
        double r5 = r3 * r2;
        double mDotR = dipoleMoment.m_82526_(pos);
        Vec3 term1 = pos.m_82490_(3.0 * mDotR / r5);
        Vec3 term2 = dipoleMoment.m_82490_(1.0 / r3);
        return term1.m_82546_(term2);
    }

    public static List<Vec3> traceFieldLine(Vec3 seed, Vec3 dipoleMoment, double stepSize, int maxSteps) {
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        Vec3 pos = seed;
        for (int i = 0; i < maxSteps; ++i) {
            points.add(pos);
            Vec3 B = RenderMagneticFieldProcedure.magneticFieldAt(pos, dipoleMoment).m_82541_();
            Vec3 next = pos.m_82549_(B.m_82490_(stepSize));
            if (next.m_82553_() > 100.0) break;
            pos = next;
        }
        return points;
    }
}

