/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.mending.helper;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class RepairGearHelper {
    public static int repairPlayerGear(ItemStack itemStack, int xpValue) {
        if (itemStack.isDamaged()) {
            int repairAmount = Math.min(RepairGearHelper.getMendingRepairAmount(xpValue), itemStack.getDamageValue());
            itemStack.setDamageValue(itemStack.getDamageValue() - repairAmount);
            int newXpValue = xpValue - RepairGearHelper.getMendingRepairCost(repairAmount);
            return newXpValue > 0 ? RepairGearHelper.repairPlayerGear(itemStack, newXpValue) : 0;
        }
        return xpValue;
    }

    public static boolean isRepairable(ItemStack itemStack) {
        return itemStack.isDamaged() && EnchantmentHelper.has((ItemStack)itemStack, (DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP);
    }

    private static int getMendingRepairCost(int repairAmount) {
        return repairAmount / 2;
    }

    private static int getMendingRepairAmount(int experienceAmount) {
        return experienceAmount * 2;
    }
}

