/*
 * Decompiled with CFR 0.152.
 */
package com.unassigned.sshook;

import com.unassigned.sshook.SSHookConfig;
import com.unassigned.sshook.packet.WebhookSyncPayload;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHook
implements ModInitializer {
    public static final String MOD_ID = "sshook";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"sshook");
    public static final class_2960 WEBHOOK_SYNC_PACKET_ID = class_2960.method_60655((String)"sshook", (String)"webhook_sync");

    public void onInitialize() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            LOGGER.info("[SSHook] Server-side installation detected, loading applicable webhooks...");
            SSHookConfig.loadConfig();
            if (!SSHookConfig.webhooks.isEmpty()) {
                LOGGER.info("[SSHook] Successfully loaded " + SSHookConfig.webhooks.size() + " webhooks!");
            } else {
                LOGGER.info("[SSHook] No webhooks were provided, connect clients will have to provide their own webhooks!");
            }
        }
        PayloadTypeRegistry.playS2C().register(WebhookSyncPayload.ID, WebhookSyncPayload.CODEC);
        if (!SSHookConfig.webhooks.isEmpty()) {
            ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
                if (entity instanceof class_3222) {
                    class_3222 player = (class_3222)entity;
                    for (Map.Entry<String, String> entry : SSHookConfig.webhooks.entrySet()) {
                        ServerPlayNetworking.send((class_3222)player, (class_8710)new WebhookSyncPayload(entry.getKey(), entry.getValue()));
                    }
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new WebhookSyncPayload("enable_bot_name_override", Boolean.toString(SSHookConfig.enableBotNameOverride)));
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new WebhookSyncPayload("custom_server_name", SSHookConfig.customServerName));
                }
            });
        }
    }
}

