/*
 * Decompiled with CFR 0.152.
 */
package com.unassigned.sshook;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.unassigned.sshook.SSHook;
import com.unassigned.sshook.SSHookClientConfig;
import com.unassigned.sshook.common.DiscordWebhook;
import com.unassigned.sshook.packet.WebhookSyncPayload;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class SSHookClient
implements ClientModInitializer {
    public static Map<String, String> SERVER_WEBHOOKS = new HashMap<String, String>();
    public static boolean SERVER_BOT_NAME_OVERRIDE = false;
    public static String SERVER_CUSTOM_NAME = "";
    public static File LAST_SCREENSHOT_FILE;

    public void onInitializeClient() {
        SSHookClientConfig.initClientConfig();
        ClientPlayNetworking.registerGlobalReceiver(WebhookSyncPayload.ID, (payload, context) -> context.client().execute(() -> {
            if (Objects.equals(payload.webhook_id(), "enable_bot_name_override")) {
                SERVER_BOT_NAME_OVERRIDE = Boolean.parseBoolean(payload.webhook_url());
            } else if (Objects.equals(payload.webhook_id(), "custom_server_name")) {
                SERVER_CUSTOM_NAME = payload.webhook_url();
            } else {
                SSHook.LOGGER.info("[SSHook] Received webhook (" + payload.webhook_id() + ") from server!");
                SERVER_WEBHOOKS.put(payload.webhook_id(), payload.webhook_url());
            }
        }));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"upload_screenshot").then(ClientCommandManager.argument((String)"webhookName", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            Map<String, String> webhooks;
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"webhookName");
            class_746 player = class_310.method_1551().field_1724;
            Map<String, String> map = webhooks = SSHookClientConfig.INSTANCE.useServerOverride ? SERVER_WEBHOOKS : SSHookClientConfig.INSTANCE.clientWebhooks;
            if (!webhooks.containsKey(name)) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Webhook \"" + name + "\" not found.")).method_27692(class_124.field_1061), false);
                return 0;
            }
            File lastScreenshotFile = LAST_SCREENSHOT_FILE;
            if (lastScreenshotFile == null || !lastScreenshotFile.exists()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"No screenshot available to upload.").method_27692(class_124.field_1061), false);
                return 0;
            }
            SSHookClient.handleDiscordWebhook(class_310.method_1551(), player, lastScreenshotFile, name, webhooks.get(name));
            return 1;
        }))));
    }

    public static void handleDiscordWebhook(class_310 instance, class_746 player, File file, String webhookName, String webhookUrl) {
        String serverAddress;
        if (player == null || webhookUrl == null) {
            return;
        }
        String playerName = player.method_5477().getString();
        String playerUUID = player.method_5845();
        class_243 pos = player.method_73189();
        String coordinates = String.format("%.2f, %.2f, %.2f", pos.field_1352, pos.field_1351, pos.field_1350);
        float yaw = player.method_36454();
        String direction = SSHookClient.getFacingDirection(yaw);
        String biome = player.method_73183().method_23753(player.method_24515()).method_40230().map(key -> key.method_29177().method_12832()).orElse("unknown").replace("_", " ").toLowerCase(Locale.ROOT);
        String dimension = player.method_73183().method_27983().method_29177().method_12832().replace("_", " ");
        String string = serverAddress = instance.method_1558() == null ? "N/A" : instance.method_1558().field_3761;
        if (!SERVER_CUSTOM_NAME.isEmpty()) {
            serverAddress = SERVER_CUSTOM_NAME;
        }
        String payloadJson = DiscordWebhook.createPayload(playerName, playerUUID, serverAddress, dimension, coordinates, direction, biome, SSHookClientConfig.INSTANCE.useServerOverride ? SERVER_BOT_NAME_OVERRIDE : SSHookClientConfig.INSTANCE.enableBotNameOverride);
        new Thread(() -> {
            try {
                DiscordWebhook.sendWebhookWithFile(webhookUrl, file.getAbsolutePath(), payloadJson);
                class_310.method_1551().execute(() -> player.method_7353((class_2561)class_2561.method_43470((String)("Screenshot uploaded to webhook: " + webhookName)).method_27692(class_124.field_1060), false));
            }
            catch (IOException e) {
                SSHook.LOGGER.error("Error sending webhook", (Throwable)e);
                class_310.method_1551().execute(() -> player.method_7353((class_2561)class_2561.method_43470((String)"Failed to upload screenshot.").method_27692(class_124.field_1061), false));
            }
        }).start();
    }

    private static String getFacingDirection(float yaw) {
        float normalizedYaw = yaw % 360.0f;
        if (normalizedYaw < 0.0f) {
            normalizedYaw += 360.0f;
        }
        if ((double)normalizedYaw >= 337.5 || (double)normalizedYaw < 22.5) {
            return "South";
        }
        if ((double)normalizedYaw >= 22.5 && (double)normalizedYaw < 67.5) {
            return "South-West";
        }
        if ((double)normalizedYaw >= 67.5 && (double)normalizedYaw < 112.5) {
            return "West";
        }
        if ((double)normalizedYaw >= 112.5 && (double)normalizedYaw < 157.5) {
            return "North-West";
        }
        if ((double)normalizedYaw >= 157.5 && (double)normalizedYaw < 202.5) {
            return "North";
        }
        if ((double)normalizedYaw >= 202.5 && (double)normalizedYaw < 247.5) {
            return "North-East";
        }
        if ((double)normalizedYaw >= 247.5 && (double)normalizedYaw < 292.5) {
            return "East";
        }
        return "South-East";
    }
}

