/*
 * Decompiled with CFR 0.152.
 */
package com.unassigned.sshook;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class SSHookConfig {
    public static Map<String, String> webhooks = new HashMap<String, String>();
    public static boolean enableBotNameOverride = true;
    public static String customServerName = "";

    public static void loadConfig() {
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve("sshook-server.json");
        if (!Files.exists(configPath, new LinkOption[0])) {
            try {
                HashMap<String, Object> defaultConfig = new HashMap<String, Object>();
                defaultConfig.put("customServerName", "play.example.com");
                defaultConfig.put("webhooks", Map.of("ExampleWebhook", "https://your.webhook/here"));
                defaultConfig.put("enableBotNameOverride", true);
                String json = new GsonBuilder().setPrettyPrinting().create().toJson(defaultConfig);
                Files.writeString(configPath, (CharSequence)json, new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (BufferedReader reader = Files.newBufferedReader(configPath);){
            JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonObject webhooksJson = obj.getAsJsonObject("webhooks");
            for (Map.Entry entry : webhooksJson.entrySet()) {
                webhooks.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            if (obj.has("enableBotNameOverride")) {
                enableBotNameOverride = obj.get("enableBotNameOverride").getAsBoolean();
            }
            if (obj.has("customServerName")) {
                customServerName = obj.get("customServerName").getAsString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

