/*
 * Decompiled with CFR 0.152.
 */
package com.unassigned.sshook.common;

import com.google.gson.Gson;
import com.unassigned.sshook.SSHook;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class DiscordWebhook {
    private static final Pattern URL_PATTERN = Pattern.compile("^https?://.*$");

    public static String createPayload(String playerName, String playerUUID, String server, String world, String coordinates, String direction, String biome, boolean enableNameOverride) {
        Gson gson = new Gson();
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        fields.add(DiscordWebhook.createField("Username", DiscordWebhook.validateString(playerName), true));
        fields.add(DiscordWebhook.createField("Server", DiscordWebhook.validateString(server), true));
        fields.add(DiscordWebhook.createField("World", DiscordWebhook.validateString(world), true));
        fields.add(DiscordWebhook.createField("Coordinates", DiscordWebhook.validateString(coordinates), true));
        fields.add(DiscordWebhook.createField("Direction", DiscordWebhook.validateString(direction), true));
        fields.add(DiscordWebhook.createField("Biome", DiscordWebhook.validateString(biome), true));
        HashMap<String, Serializable> embed = new HashMap<String, Serializable>();
        embed.put("color", Integer.valueOf(3447003));
        embed.put("fields", fields);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (enableNameOverride) {
            payload.put("username", playerName);
        }
        if (enableNameOverride) {
            payload.put("avatar_url", "https://mc-heads.net/avatar/" + playerUUID + ".png");
        }
        ArrayList<HashMap<String, Serializable>> embeds = new ArrayList<HashMap<String, Serializable>>();
        embeds.add(embed);
        payload.put("embeds", embeds);
        return gson.toJson(payload);
    }

    public static void sendWebhookWithFile(String webhookUrl, String filePath, String embedJson) throws IOException {
        File file = new File(filePath);
        String boundary = Long.toHexString(System.currentTimeMillis());
        String CRLF = "\r\n";
        URL url = new URL(webhookUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        try (OutputStream output = connection.getOutputStream();
             PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output, StandardCharsets.UTF_8), true);){
            writer.append("--" + boundary).append(CRLF);
            writer.append("Content-Disposition: form-data; name=\"payload_json\"").append(CRLF);
            writer.append("Content-Type: application/json; charset=UTF-8").append(CRLF);
            writer.append(CRLF).append(embedJson).append(CRLF).flush();
            writer.append("--" + boundary).append(CRLF);
            writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"").append(CRLF);
            writer.append("Content-Type: image/jpeg").append(CRLF);
            writer.append(CRLF).flush();
            Files.copy(file.toPath(), output);
            output.flush();
            writer.append(CRLF).flush();
            writer.append("--" + boundary + "--").append(CRLF).flush();
        }
        int responseCode = connection.getResponseCode();
        if (responseCode >= 200 && responseCode < 300) {
            SSHook.LOGGER.info("Webhook sent successfully with file.");
        } else {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getErrorStream()));){
                String inputLine;
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                SSHook.LOGGER.error("Failed to send webhook. Response code: " + responseCode);
                SSHook.LOGGER.error("Response: " + response.toString());
            }
        }
    }

    private static Map<String, Object> createField(String name, String value, boolean inline) {
        HashMap<String, Object> field = new HashMap<String, Object>();
        field.put("name", name);
        field.put("value", value);
        field.put("inline", inline);
        return field;
    }

    private static String validateString(String input) {
        if (input == null || input.trim().isEmpty()) {
            return "N/A";
        }
        return input.length() > 1024 ? input.substring(0, 1024) : input;
    }

    private static boolean isValidUrl(String url) {
        return url != null && !url.trim().isEmpty() && URL_PATTERN.matcher(url).matches();
    }
}

