/*
 * Decompiled with CFR 0.152.
 */
package com.unassigned.sshook.mixin.client;

import com.unassigned.sshook.SSHook;
import com.unassigned.sshook.SSHookClient;
import com.unassigned.sshook.SSHookClientConfig;
import java.io.File;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_318.class})
public class ScreenshotMixin {
    @Inject(method={"method_22690(Ljava/io/File;Ljava/lang/String;Lnet/minecraft/class_276;ILjava/util/function/Consumer;)V"}, at={@At(value="TAIL")})
    private static void saveScreenshot(File gameDirectory, @Nullable String fileName, class_276 framebuffer, int downscaleFactor, Consumer<class_2561> messageReceiver, CallbackInfo ci) {
        File screenshotFile;
        Map<String, String> webhooks;
        class_746 player = class_310.method_1551().field_1724;
        if (!SSHookClientConfig.INSTANCE.enableUploadPrompt || player == null) {
            return;
        }
        if (SSHookClientConfig.INSTANCE.useServerOverride) {
            if (SSHookClient.SERVER_WEBHOOKS.isEmpty()) {
                SSHook.LOGGER.info("Attempting to upload SS using webhook with no available webhooks from the server, exiting!");
                return;
            }
            webhooks = SSHookClient.SERVER_WEBHOOKS;
        } else {
            if (SSHookClientConfig.INSTANCE.clientWebhooks.isEmpty()) {
                SSHook.LOGGER.info("Attempting to upload SS using webhook with no available webhook, exiting!");
                return;
            }
            webhooks = SSHookClientConfig.INSTANCE.clientWebhooks;
        }
        File screenshotDir = new File(gameDirectory, "screenshots");
        screenshotDir.mkdirs();
        SSHookClient.LAST_SCREENSHOT_FILE = screenshotFile = fileName == null ? ScreenshotMixin.getScreenshotFilename(screenshotDir) : new File(screenshotDir, fileName);
        class_5250 message = class_2561.method_43470((String)"Upload screenshot to: ").method_27692(class_124.field_1080);
        for (Map.Entry<String, String> entry : webhooks.entrySet()) {
            String name = entry.getKey();
            class_5250 clickable = class_2561.method_43470((String)("[" + name + "]")).method_27694(style -> style.method_10977(class_124.field_1075).method_10958((class_2558)new class_2558.class_10609("/upload_screenshot " + name)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Click to upload to " + name)))));
            message.method_10852((class_2561)clickable).method_10852((class_2561)class_2561.method_43470((String)" "));
        }
        player.method_7353((class_2561)message, false);
    }

    @Unique
    private static File getScreenshotFilename(File directory) {
        String base = class_156.method_44893();
        int index = 1;
        File file;
        while ((file = new File(directory, base + (String)(index == 1 ? "" : "_" + index) + ".png")).exists()) {
            ++index;
        }
        return file;
    }
}

