/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pigmod.world.features.treedecorators;

import com.mojang.serialization.MapCodec;
import net.mcreator.pigmod.init.PigModplusModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class PigsDeathLeaveDecorator
extends LeaveVineDecorator {
    public static MapCodec<PigsDeathLeaveDecorator> CODEC = MapCodec.unit(PigsDeathLeaveDecorator::new);
    public static TreeDecoratorType<?> DECORATOR_TYPE = new TreeDecoratorType(CODEC);

    @SubscribeEvent
    public static void registerTreeDecorator(RegisterEvent event) {
        event.register(Registries.TREE_DECORATOR_TYPE, ResourceLocation.parse((String)"pig_modplus:pigs_death_tree_leave_decorator"), () -> DECORATOR_TYPE);
    }

    public PigsDeathLeaveDecorator() {
        super(0.25f);
    }

    protected TreeDecoratorType<?> type() {
        return DECORATOR_TYPE;
    }

    public void place(TreeDecorator.Context context) {
        context.leaves().forEach(blockpos -> {
            BlockPos pos;
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.west())) {
                PigsDeathLeaveDecorator.addVine(pos, Direction.WEST, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.east())) {
                PigsDeathLeaveDecorator.addVine(pos, Direction.EAST, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.north())) {
                PigsDeathLeaveDecorator.addVine(pos, Direction.NORTH, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.south())) {
                PigsDeathLeaveDecorator.addVine(pos, Direction.SOUTH, context);
            }
        });
    }

    private static void addVine(BlockPos pos, Direction direction, TreeDecorator.Context context) {
        context.setBlock(pos, ((Block)PigModplusModBlocks.PIGMAS_LEAVES.get()).defaultBlockState());
        BlockPos blockpos = pos.below();
        for (int i = 4; context.isAir(blockpos) && i > 0; --i) {
            context.setBlock(blockpos, PigsDeathLeaveDecorator.oriented(((Block)PigModplusModBlocks.PIGMAS_LEAVES.get()).defaultBlockState(), direction));
            blockpos = blockpos.below();
        }
    }

    private static BlockState oriented(BlockState blockstate, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> blockstate.rotate(Rotation.CLOCKWISE_180);
            case Direction.EAST -> blockstate.rotate(Rotation.CLOCKWISE_90);
            case Direction.WEST -> blockstate.rotate(Rotation.COUNTERCLOCKWISE_90);
            default -> blockstate;
        };
    }
}

