/*
 * Decompiled with CFR 0.152.
 */
package net.werdei.biome_replacer.replacer;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3754;
import net.minecraft.class_4766;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6544;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.werdei.biome_replacer.BiomeReplacer;
import net.werdei.biome_replacer.config.Config;
import net.werdei.biome_replacer.mixin.MultiNoiseBiomeSourceAccessor;

public class VanillaReplacer {
    private static Map<class_6880<class_1959>, class_6880<class_1959>> replacementRules;
    private static Map<String, Map<class_6880<class_1959>, class_6880<class_1959>>> dimensionReplacementRules;

    public static void doReplacement(class_2378<class_1959> biomeRegistry, class_2378<class_5363> stemRegistry) {
        VanillaReplacer.PrepareRules(biomeRegistry);
        if (replacementRules.isEmpty() && (dimensionReplacementRules == null || dimensionReplacementRules.isEmpty())) {
            BiomeReplacer.log("No rules found, not replacing anything");
            return;
        }
        HashSet<String> knownDimensions = new HashSet<String>();
        for (Iterator<String> entry : stemRegistry.method_29722()) {
            knownDimensions.add(((class_5321)entry.getKey()).method_29177().toString());
        }
        if (dimensionReplacementRules != null && !dimensionReplacementRules.isEmpty()) {
            HashMap<String, List> ruleLinesByDimension = new HashMap<String, List>();
            for (Config.Rule rule : Config.rules) {
                String dimension = rule.dimension();
                if (dimension == null) continue;
                ruleLinesByDimension.computeIfAbsent(dimension, __ -> new ArrayList()).add(rule.line());
            }
            for (String dimId : dimensionReplacementRules.keySet()) {
                List offendingLines;
                if (knownDimensions.contains(dimId) || (offendingLines = (List)ruleLinesByDimension.get(dimId)) == null) continue;
                Iterator iterator = offendingLines.iterator();
                while (iterator.hasNext()) {
                    int line = (Integer)iterator.next();
                    BiomeReplacer.logRuleWarning(line, String.format("Dimension '%s' does not exist, ignoring rule", dimId));
                }
            }
        }
        for (Map.Entry levelStem : stemRegistry.method_29722()) {
            Map<class_6880<class_1959>, class_6880<class_1959>> dimOverlay;
            class_3754 generator;
            class_2960 levelId = ((class_5321)levelStem.getKey()).method_29177();
            class_5363 level = (class_5363)levelStem.getValue();
            class_2794 line = level.method_29571();
            if (!(line instanceof class_3754) || !((generator = (class_3754)line).method_12098() instanceof class_4766)) {
                BiomeReplacer.log("Skipping " + String.valueOf(levelId));
                continue;
            }
            MultiNoiseBiomeSourceAccessor biomeSource = (MultiNoiseBiomeSourceAccessor)generator.method_12098();
            class_6544.class_6547<class_6880<class_1959>> parameters = biomeSource.getParameters();
            ArrayList<Pair> newParameterList = new ArrayList<Pair>();
            HashMap<class_6880<class_1959>, class_6880<class_1959>> merged = new HashMap<class_6880<class_1959>, class_6880<class_1959>>();
            if (replacementRules != null && !replacementRules.isEmpty()) {
                merged.putAll(replacementRules);
            }
            Map<class_6880<class_1959>, class_6880<class_1959>> map = dimOverlay = dimensionReplacementRules != null ? dimensionReplacementRules.get(levelId.toString()) : null;
            if (dimOverlay != null && !dimOverlay.isEmpty()) {
                merged.putAll(dimOverlay);
            }
            HashMap<class_6880<class_1959>, class_6880<class_1959>> effectiveRules = merged;
            for (Pair value : parameters.method_38128()) {
                class_6880<class_1959> newBiome = VanillaReplacer.replaceFromMap((class_6880<class_1959>)((class_6880)value.getSecond()), effectiveRules);
                if (newBiome == null) continue;
                newParameterList.add(new Pair((Object)((class_6544.class_4762)value.getFirst()), newBiome));
            }
            biomeSource.setParameters((class_6544.class_6547<class_6880<class_1959>>)new class_6544.class_6547(newParameterList));
            BiomeReplacer.log("Successfully replaced biomes in " + String.valueOf(levelId));
        }
    }

    private static void PrepareRules(class_2378<class_1959> biomeRegistry) {
        replacementRules = new HashMap<class_6880<class_1959>, class_6880<class_1959>>();
        dimensionReplacementRules = new HashMap<String, Map<class_6880<class_1959>, class_6880<class_1959>>>();
        int rulesDirect = 0;
        int rulesTag = 0;
        int rulesIgnored = 0;
        for (Config.Rule rule : Config.rules) {
            try {
                class_6880<class_1959> newBiome;
                Map targetMap;
                Map map = targetMap = rule.dimension() == null ? replacementRules : dimensionReplacementRules.computeIfAbsent(rule.dimension(), k -> new HashMap());
                if (rule.from().startsWith("#")) {
                    class_6862<class_1959> tagKey = VanillaReplacer.getBiomeTagKey(rule.from().substring(1));
                    newBiome = VanillaReplacer.getBiomeHolder(rule.to(), biomeRegistry);
                    for (class_6880 oldBiome : biomeRegistry.method_40286(tagKey)) {
                        targetMap.putIfAbsent(oldBiome, newBiome);
                    }
                    ++rulesTag;
                    continue;
                }
                class_6880<class_1959> oldBiome = VanillaReplacer.getBiomeHolder(rule.from(), biomeRegistry);
                newBiome = VanillaReplacer.getBiomeHolder(rule.to(), biomeRegistry);
                targetMap.put(oldBiome, newBiome);
                ++rulesDirect;
            }
            catch (Exception e) {
                BiomeReplacer.logRuleWarning(rule.line(), e.getMessage() + ", ignoring rule");
                ++rulesIgnored;
            }
        }
        BiomeReplacer.log(String.format("Loaded %d rules (%d direct, %d tag-based) and ignored %d", rulesDirect + rulesTag, rulesDirect, rulesTag, rulesIgnored));
    }

    private static class_6880<class_1959> getBiomeHolder(String id, class_2378<class_1959> registry) throws Exception {
        if (id.equals("null")) {
            return null;
        }
        class_5321<class_1959> resourceKey = VanillaReplacer.getBiomeResourceKey(id);
        Optional holder = registry.method_40264(resourceKey);
        if (holder.isPresent()) {
            return (class_6880)holder.get();
        }
        throw new Exception(String.format("Biome '%s' does not exist", id));
    }

    private static class_5321<class_1959> getBiomeResourceKey(String id) throws Exception {
        class_2960 resourceLocation = class_2960.method_12829((String)id);
        if (resourceLocation == null) {
            throw new Exception(String.format("Invalid biome ID '%s'", id));
        }
        return class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)resourceLocation);
    }

    private static class_6862<class_1959> getBiomeTagKey(String id) throws Exception {
        class_2960 resourceLocation = class_2960.method_12829((String)id);
        if (resourceLocation == null) {
            throw new Exception(String.format("Invalid biome tag '#%s'", id));
        }
        return class_6862.method_40092((class_5321)class_2378.field_25114, (class_2960)resourceLocation);
    }

    public static class_6880<class_1959> replaceIfNeeded(class_6880<class_1959> original) {
        return VanillaReplacer.replaceIfNeeded(original, null);
    }

    public static class_6880<class_1959> replaceIfNeeded(class_6880<class_1959> original, String dimensionId) {
        if (dimensionId == null || dimensionReplacementRules == null || dimensionReplacementRules.isEmpty()) {
            return VanillaReplacer.replaceFromMap(original, replacementRules);
        }
        Map<class_6880<class_1959>, class_6880<class_1959>> dimensionRules = dimensionReplacementRules.get(dimensionId);
        if (dimensionRules == null || dimensionRules.isEmpty()) {
            return VanillaReplacer.replaceFromMap(original, replacementRules);
        }
        if (replacementRules == null || replacementRules.isEmpty()) {
            return VanillaReplacer.replaceFromMap(original, dimensionRules);
        }
        HashMap<class_6880<class_1959>, class_6880<class_1959>> merged = new HashMap<class_6880<class_1959>, class_6880<class_1959>>(replacementRules);
        merged.putAll(dimensionRules);
        return VanillaReplacer.replaceFromMap(original, merged);
    }

    private static class_6880<class_1959> replaceFromMap(class_6880<class_1959> original, Map<class_6880<class_1959>, class_6880<class_1959>> rules) {
        if (rules == null || rules.isEmpty()) {
            return original;
        }
        return rules.getOrDefault(original, original);
    }
}

